/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.AutoValue_Window;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoValue
public abstract class Window<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<T>> {
    public static <T> @UnknownKeyFor @NonNull @Initialized Window<T> into(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> fn) {
        try {
            fn.windowCoder().verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new IllegalArgumentException("Window coders must be deterministic.", e);
        }
        return super.withWindowFn(fn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Window<T> configure() {
        return new AutoValue_Window.Builder().build();
    }

    public abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized WindowFn<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowFn();

    abstract @Nullable @UnknownKeyFor @Initialized Trigger getTrigger();

    abstract @Nullable @UnknownKeyFor @Initialized WindowingStrategy.AccumulationMode getAccumulationMode();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getAllowedLateness();

    abstract @Nullable @UnknownKeyFor @Initialized ClosingBehavior getClosingBehavior();

    abstract @Nullable @UnknownKeyFor @Initialized OnTimeBehavior getOnTimeBehavior();

    abstract @Nullable @UnknownKeyFor @Initialized TimestampCombiner getTimestampCombiner();

    abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

    private @UnknownKeyFor @NonNull @Initialized Window<T> withWindowFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowFn) {
        return this.toBuilder().setWindowFn(windowFn).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public @UnknownKeyFor @NonNull @Initialized Window<T> triggering(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
        return this.toBuilder().setTrigger(trigger).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public @UnknownKeyFor @NonNull @Initialized Window<T> discardingFiredPanes() {
        return this.toBuilder().setAccumulationMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public @UnknownKeyFor @NonNull @Initialized Window<T> accumulatingFiredPanes() {
        return this.toBuilder().setAccumulationMode(WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public @UnknownKeyFor @NonNull @Initialized Window<T> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
        return this.toBuilder().setAllowedLateness(allowedLateness).build();
    }

    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public @UnknownKeyFor @NonNull @Initialized Window<T> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
        return this.toBuilder().setTimestampCombiner(timestampCombiner).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public @UnknownKeyFor @NonNull @Initialized Window<T> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, @UnknownKeyFor @NonNull @Initialized ClosingBehavior behavior) {
        return this.toBuilder().setAllowedLateness(allowedLateness).setClosingBehavior(behavior).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public @UnknownKeyFor @NonNull @Initialized Window<T> withOnTimeBehavior(@UnknownKeyFor @NonNull @Initialized OnTimeBehavior behavior) {
        return this.toBuilder().setOnTimeBehavior(behavior).build();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getOutputStrategyInternal(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> inputStrategy) {
        WindowingStrategy<?, ?> result = inputStrategy;
        if (this.getWindowFn() != null) {
            result = result.withAlreadyMerged(false).withWindowFn(this.getWindowFn());
        }
        if (this.getTrigger() != null) {
            result = result.withTrigger(this.getTrigger());
        }
        if (this.getAccumulationMode() != null) {
            result = result.withMode(this.getAccumulationMode());
        }
        if (this.getAllowedLateness() != null) {
            result = result.withAllowedLateness((Duration)Ordering.natural().max((Object)this.getAllowedLateness(), (Object)inputStrategy.getAllowedLateness()));
        }
        if (this.getClosingBehavior() != null) {
            result = result.withClosingBehavior(this.getClosingBehavior());
        }
        if (this.getOnTimeBehavior() != null) {
            result = result.withOnTimeBehavior(this.getOnTimeBehavior());
        }
        if (this.getTimestampCombiner() != null) {
            result = result.withTimestampCombiner(this.getTimestampCombiner());
        }
        return result;
    }

    private void applicableTo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategyInternal(input.getWindowingStrategy());
        if (outputStrategy.isTriggerSpecified() && !(outputStrategy.getTrigger() instanceof DefaultTrigger) && !(outputStrategy.getWindowFn() instanceof GlobalWindows) && !outputStrategy.isAllowedLatenessSpecified()) {
            throw new IllegalArgumentException("Except when using GlobalWindows, calling .triggering() to specify a trigger requires that the allowed lateness be specified using .withAllowedLateness() to set the upper bound on how late data can arrive before being dropped. See Javadoc for more details.");
        }
        if (!outputStrategy.isModeSpecified() && this.canProduceMultiplePanes(outputStrategy)) {
            throw new IllegalArgumentException("Calling .triggering() to specify a trigger or calling .withAllowedLateness() to specify an allowed lateness greater than zero requires that the accumulation mode be specified using .discardingFiredPanes() or .accumulatingFiredPanes(). See Javadoc for more details.");
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean canProduceMultiplePanes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> strategy) {
        boolean dataCanArriveLate = !(strategy.getWindowFn() instanceof GlobalWindows) && strategy.getAllowedLateness().getMillis() > 0L;
        boolean hasCustomTrigger = !(strategy.getTrigger() instanceof DefaultTrigger);
        return dataCanArriveLate || hasCustomTrigger;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
        this.applicableTo(input);
        WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategyInternal(input.getWindowingStrategy());
        if (this.getWindowFn() == null) {
            return ((PCollection)PCollectionList.of(input).apply(Flatten.pCollections())).setWindowingStrategyInternal(outputStrategy);
        }
        return (PCollection)input.apply(new Assign(this, outputStrategy));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        if (this.getWindowFn() != null) {
            builder.add(DisplayData.item("windowFn", this.getWindowFn().getClass()).withLabel("Windowing Function")).include("windowFn", this.getWindowFn());
        }
        if (this.getAllowedLateness() != null) {
            builder.addIfNotDefault(DisplayData.item("allowedLateness", this.getAllowedLateness()).withLabel("Allowed Lateness"), Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
        }
        if (this.getTrigger() != null && !(this.getTrigger() instanceof DefaultTrigger)) {
            builder.add(DisplayData.item("trigger", this.getTrigger().toString()).withLabel("Trigger"));
        }
        if (this.getAccumulationMode() != null) {
            builder.add(DisplayData.item("accumulationMode", this.getAccumulationMode().toString()).withLabel("Accumulation Mode"));
        }
        if (this.getClosingBehavior() != null) {
            builder.add(DisplayData.item("closingBehavior", this.getClosingBehavior().toString()).withLabel("Window Closing Behavior"));
        }
        if (this.getTimestampCombiner() != null) {
            builder.add(DisplayData.item("timestampCombiner", this.getTimestampCombiner().toString()).withLabel("Timestamp Combiner"));
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
        return "Window.Into()";
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Remerge<T> remerge() {
        return new Remerge();
    }

    private static class Remerge<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Remerge() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return ((PCollection)input.apply("Identity", MapElements.via(new SimpleFunction<T, T>(){

                @Override
                public T apply(T element) {
                    return element;
                }
            }))).setWindowingStrategyInternal(input.getWindowingStrategy().withAlreadyMerged(false));
        }
    }

    public static class Assign<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized Window<T> original;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> updatedStrategy;

        @VisibleForTesting
        Assign(@UnknownKeyFor @NonNull @Initialized Window<T> original, @UnknownKeyFor @NonNull @Initialized WindowingStrategy updatedStrategy) {
            this.original = original;
            this.updatedStrategy = updatedStrategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), this.updatedStrategy, input.isBounded(), input.getCoder());
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.original.populateDisplayData(builder);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized WindowFn<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowFn() {
            return this.updatedStrategy.getWindowFn();
        }
    }

    @AutoValue.Builder
    static abstract class Builder<@UnknownKeyFor T> {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWindowFn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTrigger(@UnknownKeyFor @NonNull @Initialized Trigger var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAccumulationMode(@UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setClosingBehavior(@UnknownKeyFor @NonNull @Initialized ClosingBehavior var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setOnTimeBehavior(@UnknownKeyFor @NonNull @Initialized OnTimeBehavior var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner var1);

        abstract @UnknownKeyFor @NonNull @Initialized Window<T> build();
    }

    public static enum OnTimeBehavior {
        FIRE_ALWAYS,
        FIRE_IF_NON_EMPTY;

    }

    public static enum ClosingBehavior {
        FIRE_ALWAYS,
        FIRE_IF_NON_EMPTY;

    }
}

