/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.auth;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GcpCredentialFactory
implements CredentialFactory {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> oauthScopes;
    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> impersonateServiceAccountChain;

    private GcpCredentialFactory(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> oauthScopes, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> impersonateServiceAccountChain) {
        if (impersonateServiceAccountChain != null) {
            Preconditions.checkArgument((impersonateServiceAccountChain.size() > 0 ? 1 : 0) != 0);
        }
        this.oauthScopes = oauthScopes;
        this.impersonateServiceAccountChain = impersonateServiceAccountChain;
    }

    public static @UnknownKeyFor @NonNull @Initialized GcpCredentialFactory fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        GcpOptions gcpOptions = (GcpOptions)options.as(GcpOptions.class);
        @Nullable String impersonateServiceAccountArg = gcpOptions.getImpersonateServiceAccount();
        @Nullable List<String> impersonateServiceAccountChain = impersonateServiceAccountArg == null ? null : Arrays.asList(impersonateServiceAccountArg.split(","));
        return new GcpCredentialFactory(gcpOptions.getGcpOauthScopes(), impersonateServiceAccountChain);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Credentials getCredential() {
        try {
            GoogleCredentials applicationDefaultCredentials = GoogleCredentials.getApplicationDefault().createScoped(this.oauthScopes);
            if (this.impersonateServiceAccountChain == null) {
                return applicationDefaultCredentials;
            }
            String targetPrincipal = this.impersonateServiceAccountChain.get(this.impersonateServiceAccountChain.size() - 1);
            List<String> delegationChain = this.impersonateServiceAccountChain.subList(0, this.impersonateServiceAccountChain.size() - 1);
            ImpersonatedCredentials impersonationCredentials = ImpersonatedCredentials.create((GoogleCredentials)applicationDefaultCredentials, (String)targetPrincipal, delegationChain, this.oauthScopes, (int)0);
            return impersonationCredentials;
        }
        catch (IOException e) {
            return null;
        }
    }
}

