/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_CustomHttpErrors_MatcherAndError;
import org.apache.beam.sdk.extensions.gcp.util.HttpCallCustomError;
import org.apache.beam.sdk.extensions.gcp.util.HttpCallMatcher;
import org.apache.beam.sdk.extensions.gcp.util.HttpRequestWrapper;
import org.apache.beam.sdk.extensions.gcp.util.HttpResponseWrapper;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CustomHttpErrors {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatcherAndError> matchersAndLogs = new ArrayList<MatcherAndError>();

    private CustomHttpErrors(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatcherAndError> matchersAndLogs) {
        for (MatcherAndError m : matchersAndLogs) {
            this.matchersAndLogs.add(m);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized String getCustomError(@UnknownKeyFor @NonNull @Initialized HttpRequestWrapper req, @UnknownKeyFor @NonNull @Initialized HttpResponseWrapper res) {
        for (MatcherAndError m : this.matchersAndLogs) {
            if (!m.getMatcher().matchResponse(req, res)) continue;
            return m.getCustomError().customError(req, res);
        }
        return null;
    }

    public static class Builder {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatcherAndError> matchersAndLogs = new ArrayList<MatcherAndError>();

        public @UnknownKeyFor @NonNull @Initialized CustomHttpErrors build() {
            return new CustomHttpErrors(this.matchersAndLogs);
        }

        public void addErrorForCode(@UnknownKeyFor @NonNull @Initialized int statusCode, @UnknownKeyFor @NonNull @Initialized String errorMessage) {
            HttpCallMatcher matcher = (req, resp) -> resp.getStatusCode() == statusCode;
            this.matchersAndLogs.add(MatcherAndError.create(matcher, Builder.simpleErrorMessage(errorMessage)));
        }

        public void addErrorForCodeAndUrlContains(@UnknownKeyFor @NonNull @Initialized int statusCode, @UnknownKeyFor @NonNull @Initialized String urlContains, @UnknownKeyFor @NonNull @Initialized String errorMessage) {
            HttpCallMatcher matcher = (request, response) -> response.getStatusCode() == statusCode && request.getUrl().toString().contains(urlContains);
            this.matchersAndLogs.add(MatcherAndError.create(matcher, Builder.simpleErrorMessage(errorMessage)));
        }

        private static @UnknownKeyFor @NonNull @Initialized HttpCallCustomError simpleErrorMessage(@UnknownKeyFor @NonNull @Initialized String errorMessage) {
            return (request, response) -> errorMessage;
        }
    }

    @AutoValue
    public static abstract class MatcherAndError
    implements Serializable {
        static @UnknownKeyFor @NonNull @Initialized MatcherAndError create(@UnknownKeyFor @NonNull @Initialized HttpCallMatcher matcher, @UnknownKeyFor @NonNull @Initialized HttpCallCustomError customError) {
            return new AutoValue_CustomHttpErrors_MatcherAndError(matcher, customError);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized HttpCallMatcher getMatcher();

        public abstract @UnknownKeyFor @NonNull @Initialized HttpCallCustomError getCustomError();
    }
}

