/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util.gcsfs;

import com.google.api.services.storage.model.StorageObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class GcsPath
implements Path,
Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized String SCHEME = "gs";
    public static final @UnknownKeyFor @NonNull @Initialized Pattern GCS_URI = Pattern.compile("(?<SCHEME>[^:]+)://(?<BUCKET>[^/]+)(/(?<OBJECT>.*))?");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GCS_RESOURCE_NAME = Pattern.compile("storage.googleapis.com/(?<BUCKET>[^/]+)(/(?<OBJECT>.*))?");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GCS_BUCKET_NAME = Pattern.compile("[a-z0-9][-_a-z0-9.]+[a-z0-9]");
    private transient @Nullable @UnknownKeyFor @Initialized FileSystem fs;
    @Nonnull
    private final @UnknownKeyFor @NonNull @Initialized String bucket;
    @Nonnull
    private final @UnknownKeyFor @NonNull @Initialized String object;

    public static @UnknownKeyFor @NonNull @Initialized GcsPath fromUri(@UnknownKeyFor @NonNull @Initialized URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equalsIgnoreCase(SCHEME), (String)"URI: %s is not a GCS URI", (Object)uri);
        Preconditions.checkArgument((uri.getPort() == -1 ? 1 : 0) != 0, (String)"GCS URI may not specify port: %s (%s)", (Object)uri, (int)uri.getPort());
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getUserInfo()), (String)"GCS URI may not specify userInfo: %s (%s)", (Object)uri, (Object)uri.getUserInfo());
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getQuery()), (String)"GCS URI may not specify query: %s (%s)", (Object)uri, (Object)uri.getQuery());
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)uri.getFragment()), (String)"GCS URI may not specify fragment: %s (%s)", (Object)uri, (Object)uri.getFragment());
        return GcsPath.fromUri(uri.toString());
    }

    public static @UnknownKeyFor @NonNull @Initialized GcsPath fromUri(@UnknownKeyFor @NonNull @Initialized String uri) {
        Matcher m = GCS_URI.matcher(uri);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Invalid GCS URI: %s", (Object)uri);
        Preconditions.checkArgument((boolean)m.group("SCHEME").equalsIgnoreCase(SCHEME), (String)"URI: %s is not a GCS URI", (Object)uri);
        return new GcsPath(null, m.group("BUCKET"), m.group("OBJECT"));
    }

    public static @UnknownKeyFor @NonNull @Initialized GcsPath fromResourceName(@UnknownKeyFor @NonNull @Initialized String name) {
        Matcher m = GCS_RESOURCE_NAME.matcher(name);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Invalid GCS resource name: %s", (Object)name);
        return new GcsPath(null, m.group("BUCKET"), m.group("OBJECT"));
    }

    public static @UnknownKeyFor @NonNull @Initialized GcsPath fromObject(@UnknownKeyFor @NonNull @Initialized StorageObject object) {
        return new GcsPath(null, object.getBucket(), object.getName());
    }

    public static @UnknownKeyFor @NonNull @Initialized GcsPath fromComponents(@Nullable @UnknownKeyFor @Initialized String bucket, @Nullable @UnknownKeyFor @Initialized String object) {
        return new GcsPath(null, bucket, object);
    }

    public GcsPath(@Nullable @UnknownKeyFor @Initialized FileSystem fs, @Nullable @UnknownKeyFor @Initialized String bucket, @Nullable @UnknownKeyFor @Initialized String object) {
        if (bucket == null) {
            bucket = "";
        }
        Preconditions.checkArgument((!bucket.contains("/") ? 1 : 0) != 0, (Object)"GCS bucket may not contain a slash");
        Preconditions.checkArgument((bucket.isEmpty() || GCS_BUCKET_NAME.matcher(bucket).matches() ? 1 : 0) != 0, (Object)("GCS bucket names must contain only lowercase letters, numbers, dashes (-), underscores (_), and dots (.). Bucket names must start and end with a number or letter. See https://developers.google.com/storage/docs/bucketnaming for more details.  Bucket name: " + bucket));
        if (object == null) {
            object = "";
        }
        Preconditions.checkArgument((object.indexOf(10) < 0 && object.indexOf(13) < 0 ? 1 : 0) != 0, (Object)"GCS object names must not contain Carriage Return or Line Feed characters.");
        this.fs = fs;
        this.bucket = bucket;
        this.object = object;
    }

    public @UnknownKeyFor @NonNull @Initialized String getBucket() {
        return this.bucket;
    }

    public @UnknownKeyFor @NonNull @Initialized String getObject() {
        return this.object;
    }

    public void setFileSystem(@UnknownKeyFor @NonNull @Initialized FileSystem fs) {
        this.fs = fs;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean isAbsolute() {
        return !this.bucket.isEmpty() || this.object.isEmpty();
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized GcsPath getRoot() {
        return new GcsPath(this.fs, "", "");
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized GcsPath getFileName() {
        int nameCount = this.getNameCount();
        if (nameCount < 2) {
            throw new UnsupportedOperationException("Can't get filename from root path in the bucket: " + this);
        }
        return this.getName(nameCount - 1);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized GcsPath getParent() {
        if (this.bucket.isEmpty() && this.object.isEmpty()) {
            return null;
        }
        if (this.object.isEmpty()) {
            return this.getRoot();
        }
        int i = this.object.lastIndexOf(47, this.object.length() - 2);
        if (i <= 0) {
            if (this.bucket.isEmpty()) {
                return null;
            }
            return new GcsPath(this.fs, this.bucket, "");
        }
        return new GcsPath(this.fs, this.bucket, this.object.substring(0, i + 1));
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int getNameCount() {
        int count;
        int n = count = this.bucket.isEmpty() ? 0 : 1;
        if (this.object.isEmpty()) {
            return count;
        }
        int index = -1;
        while ((index = this.object.indexOf(47, index + 1)) != -1) {
            ++count;
        }
        return this.object.endsWith("/") ? count : count + 1;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized GcsPath getName(@UnknownKeyFor @NonNull @Initialized int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        Iterator<Path> iterator = this.iterator();
        for (int i = 0; i < count; ++i) {
            Preconditions.checkArgument((boolean)iterator.hasNext());
            iterator.next();
        }
        Preconditions.checkArgument((boolean)iterator.hasNext());
        return (GcsPath)iterator.next();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized GcsPath subpath(@UnknownKeyFor @NonNull @Initialized int beginIndex, @UnknownKeyFor @NonNull @Initialized int endIndex) {
        Preconditions.checkArgument((beginIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((endIndex > beginIndex ? 1 : 0) != 0);
        Iterator<Path> iterator = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            Preconditions.checkArgument((boolean)iterator.hasNext());
            iterator.next();
        }
        GcsPath path = null;
        while (beginIndex < endIndex) {
            Preconditions.checkArgument((boolean)iterator.hasNext());
            path = path == null ? (GcsPath)iterator.next() : path.resolve(iterator.next());
            ++beginIndex;
        }
        return path;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean startsWith(@UnknownKeyFor @NonNull @Initialized Path other) {
        if (other instanceof GcsPath) {
            GcsPath gcsPath = (GcsPath)other;
            return this.startsWith(gcsPath.bucketAndObject());
        }
        return this.startsWith(other.toString());
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean startsWith(@UnknownKeyFor @NonNull @Initialized String prefix) {
        return this.bucketAndObject().startsWith(prefix);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean endsWith(@UnknownKeyFor @NonNull @Initialized Path other) {
        if (other instanceof GcsPath) {
            GcsPath gcsPath = (GcsPath)other;
            return this.endsWith(gcsPath.bucketAndObject());
        }
        return this.endsWith(other.toString());
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean endsWith(@UnknownKeyFor @NonNull @Initialized String suffix) {
        return this.bucketAndObject().endsWith(suffix);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized GcsPath normalize() {
        return this;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized GcsPath resolve(@UnknownKeyFor @NonNull @Initialized Path other) {
        if (other instanceof GcsPath) {
            GcsPath path = (GcsPath)other;
            if (path.isAbsolute()) {
                return path;
            }
            return this.resolve(path.getObject());
        }
        return this.resolve(other.toString());
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized GcsPath resolve(@UnknownKeyFor @NonNull @Initialized String other) {
        if (this.bucket.isEmpty() && this.object.isEmpty()) {
            other = "gs://" + other;
        }
        if (other.startsWith("gs://")) {
            GcsPath path = GcsPath.fromUri(other);
            path.setFileSystem(this.getFileSystem());
            return path;
        }
        if (other.isEmpty()) {
            other = "/";
        }
        if (this.object.isEmpty()) {
            return new GcsPath(this.fs, this.bucket, other);
        }
        if (this.object.endsWith("/")) {
            return new GcsPath(this.fs, this.bucket, this.object + other);
        }
        return new GcsPath(this.fs, this.bucket, this.object + "/" + other);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized Path resolveSibling(@UnknownKeyFor @NonNull @Initialized Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized Path resolveSibling(@UnknownKeyFor @NonNull @Initialized String other) {
        if (this.getNameCount() < 2) {
            throw new UnsupportedOperationException("Can't resolve the sibling of a root path: " + this);
        }
        GcsPath parent = this.getParent();
        return parent == null ? GcsPath.fromUri(other) : parent.resolve(other);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized Path relativize(@UnknownKeyFor @NonNull @Initialized Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized GcsPath toAbsolutePath() {
        return this;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized GcsPath toRealPath(LinkOption ... options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WatchKey register(@UnknownKeyFor @NonNull @Initialized WatchService watcher, /*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized WatchEvent.Kind<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] events, WatchEvent.Modifier ... modifiers) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WatchKey register(@UnknownKeyFor @NonNull @Initialized WatchService watcher, WatchEvent.Kind<?> ... events) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Path> iterator() {
        return new NameIterator(this.fs, !this.bucket.isEmpty(), this.bucketAndObject());
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized Path other) {
        if (!(other instanceof GcsPath)) {
            throw new ClassCastException();
        }
        GcsPath path = (GcsPath)other;
        int b = this.bucket.compareTo(path.bucket);
        if (b != 0) {
            return b;
        }
        Iterator<Path> left = this.iterator();
        Iterator<Path> right = path.iterator();
        while (left.hasNext() && right.hasNext()) {
            String rightStr;
            String leftStr = left.next().toString();
            int c = leftStr.compareTo(rightStr = right.next().toString());
            if (c == 0) continue;
            return c;
        }
        if (!left.hasNext() && !right.hasNext()) {
            return 0;
        }
        return left.hasNext() ? 1 : -1;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcsPath paths = (GcsPath)o;
        return this.bucket.equals(paths.bucket) && this.object.equals(paths.object);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + this.object.hashCode();
        return result;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        if (!this.isAbsolute()) {
            return this.object;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SCHEME).append("://");
        if (!this.bucket.isEmpty()) {
            sb.append(this.bucket).append('/');
        }
        sb.append(this.object);
        return sb.toString();
    }

    public @UnknownKeyFor @NonNull @Initialized String toResourceName() {
        StringBuilder sb = new StringBuilder();
        sb.append("storage.googleapis.com/");
        if (!this.bucket.isEmpty()) {
            sb.append(this.bucket).append('/');
        }
        sb.append(this.object);
        return sb.toString();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized URI toUri() {
        try {
            return new URI(SCHEME, "//" + this.bucketAndObject(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create URI for GCS path " + this);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String bucketAndObject() {
        if (this.bucket.isEmpty()) {
            return this.object;
        }
        return this.bucket + "/" + this.object;
    }

    private static class NameIterator
    implements Iterator<Path> {
        private final @UnknownKeyFor @NonNull @Initialized FileSystem fs;
        private @UnknownKeyFor @NonNull @Initialized boolean fullPath;
        private @UnknownKeyFor @NonNull @Initialized String name;

        NameIterator(@UnknownKeyFor @NonNull @Initialized FileSystem fs, @UnknownKeyFor @NonNull @Initialized boolean fullPath, @UnknownKeyFor @NonNull @Initialized String name) {
            this.fs = fs;
            this.fullPath = fullPath;
            this.name = name;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return !Strings.isNullOrEmpty((String)this.name);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GcsPath next() {
            String component;
            int i = this.name.indexOf(47);
            if (i >= 0) {
                component = this.name.substring(0, i);
                this.name = this.name.substring(i + 1);
            } else {
                component = this.name;
                this.name = null;
            }
            if (this.fullPath) {
                this.fullPath = false;
                return new GcsPath(this.fs, component, "");
            }
            return new GcsPath(this.fs, "", component);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

