/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.rpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcResultPartitionConsumableNotifier
implements ResultPartitionConsumableNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(RpcResultPartitionConsumableNotifier.class);
    private final JobMasterGateway jobMasterGateway;
    private final Executor executor;
    private final Time timeout;

    public RpcResultPartitionConsumableNotifier(JobMasterGateway jobMasterGateway, Executor executor, Time timeout) {
        this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public void notifyPartitionConsumable(JobID jobId, ResultPartitionID partitionId, TaskActions taskActions) {
        CompletableFuture<Acknowledge> acknowledgeFuture = this.jobMasterGateway.notifyPartitionDataAvailable(partitionId, this.timeout);
        acknowledgeFuture.whenCompleteAsync((ack, throwable) -> {
            if (throwable != null) {
                LOG.error("Could not notify partition data available to JobManager.", throwable);
                taskActions.failExternally(new RuntimeException("Could not notify partition data available to JobManager.", (Throwable)throwable));
            }
        }, this.executor);
    }
}

