/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseDoubleValue
implements ClickHouseValue {
    private boolean isNull;
    private double value;

    public static ClickHouseDoubleValue ofNull() {
        return ClickHouseDoubleValue.ofNull(null);
    }

    public static ClickHouseDoubleValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseDoubleValue ? ((ClickHouseDoubleValue)ref).set(true, 0.0) : new ClickHouseDoubleValue(true, 0.0);
    }

    public static ClickHouseDoubleValue of(double value) {
        return ClickHouseDoubleValue.of(null, value);
    }

    public static ClickHouseDoubleValue of(ClickHouseValue ref, double value) {
        return ref instanceof ClickHouseDoubleValue ? ((ClickHouseDoubleValue)ref).set(false, value) : new ClickHouseDoubleValue(false, value);
    }

    protected ClickHouseDoubleValue(boolean isNull, double value) {
        this.set(isNull, value);
    }

    protected ClickHouseDoubleValue set(boolean isNull, double value) {
        this.isNull = isNull;
        this.value = isNull ? 0.0 : value;
        return this;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public ClickHouseDoubleValue copy(boolean deep) {
        return new ClickHouseDoubleValue(this.isNull, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInteger() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigDecimal.valueOf(this.value).toBigInteger();
    }

    @Override
    public float asFloat() {
        return (float)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (this.isNull) {
            return null;
        }
        if (Double.isNaN(this.value) || this.value == Double.POSITIVE_INFINITY || this.value == Double.NEGATIVE_INFINITY) {
            throw new NumberFormatException("Infinite or NaN");
        }
        if (this.value == 0.0) {
            return BigDecimal.ZERO;
        }
        if (this.value == 1.0) {
            return BigDecimal.ONE;
        }
        return new BigDecimal(Double.toString(this.value));
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        if (this.isNull) {
            return null;
        }
        if (Double.isNaN(this.value) || this.value == Double.POSITIVE_INFINITY || this.value == Double.NEGATIVE_INFINITY) {
            throw new NumberFormatException("Infinite or NaN");
        }
        BigDecimal dec = BigDecimal.valueOf(this.value);
        if (this.value == 0.0) {
            dec = dec.setScale(scale);
        } else {
            int diff = scale - dec.scale();
            if (diff > 0) {
                dec = dec.divide(BigDecimal.TEN.pow(diff + 1));
            } else if (diff < 0) {
                dec = dec.setScale(scale, ClickHouseValues.ROUNDING_MODE);
            }
        }
        return dec;
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Double.valueOf(this.getValue());
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNull) {
            return null;
        }
        String str = String.valueOf(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseDoubleValue resetToDefault() {
        return this.set(false, 0.0);
    }

    @Override
    public ClickHouseDoubleValue resetToNullOrEmpty() {
        return this.set(true, 0.0);
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.value == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return String.valueOf(this.value);
    }

    @Override
    public ClickHouseDoubleValue update(boolean value) {
        return this.set(false, value ? 1.0 : 0.0);
    }

    @Override
    public ClickHouseDoubleValue update(char value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(int value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(long value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(float value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(double value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseDoubleValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.doubleValue());
    }

    @Override
    public ClickHouseDoubleValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.doubleValue());
    }

    @Override
    public ClickHouseDoubleValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.ordinal());
    }

    @Override
    public ClickHouseDoubleValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, Double.parseDouble(value));
    }

    @Override
    public ClickHouseDoubleValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.asDouble());
    }

    @Override
    public ClickHouseDoubleValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).doubleValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asDouble());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseDoubleValue v = (ClickHouseDoubleValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + (int)(l ^ l >>> 32);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

