/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data.tsv;

import java.io.IOException;
import java.io.InputStream;

public final class FastByteArrayInputStream
extends InputStream {
    private final byte[] buf;
    private int pos;
    private final int count;

    public FastByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.count = buf.length;
    }

    public FastByteArrayInputStream(byte[] buf, int count) {
        this.buf = buf;
        this.pos = 0;
        this.count = count;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos += (int)n;
        return n;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public int getPos() {
        return this.pos;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public byte[] getData() {
        if (this.buf.length > this.count) {
            byte[] data = new byte[this.count];
            System.arraycopy(this.buf, 0, data, 0, this.count);
            return data;
        }
        return this.buf;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }
}

