/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.kafka.ProducerSpEL;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.SinkMetrics;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalCause;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.UnmodifiableIterator;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaExactlyOnceSink<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<ProducerRecord<K, V>>, PCollection<Void>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaExactlyOnceSink.class);
    private static final @UnknownKeyFor @NonNull @Initialized String METRIC_NAMESPACE = "KafkaExactlyOnceSink";
    private final  @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec;

    static void ensureEOSSupport() {
        Preconditions.checkArgument((boolean)ProducerSpEL.supportsTransactions(), (String)"%s %s", (Object)"This version of Kafka client does not support transactions required to support", (Object)"exactly-once semantics. Please use Kafka client version 0.11 or newer.");
    }

    KafkaExactlyOnceSink( @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec) {
        this.spec = spec;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @Nullable @Initialized Void> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V>> input) {
        String topic = (String)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.spec.getTopic());
        int numShards = this.spec.getNumShards();
        if (numShards <= 0) {
            try (Consumer<K, K> consumer = KafkaExactlyOnceSink.openConsumer(this.spec);){
                numShards = consumer.partitionsFor(topic).size();
                LOG.info("Using {} shards for exactly-once writer, matching number of partitions for topic '{}'", (Object)numShards, (Object)this.spec.getTopic());
            }
        }
        Preconditions.checkState((numShards > 0 ? 1 : 0) != 0, (Object)"Could not set number of shards");
        return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).discardingFiredPanes())).apply(String.format("Shuffle across %d shards", numShards), (PTransform)ParDo.of(new Reshard(numShards)))).apply("Persist sharding", (PTransform)GroupByKey.create())).apply("Assign sequential ids", (PTransform)ParDo.of(new Sequencer()))).apply("Persist ids", (PTransform)GroupByKey.create())).apply(String.format("Write to Kafka topic '%s'", this.spec.getTopic()), (PTransform)ParDo.of(new ExactlyOnceWriter<K, V>(this.spec, input.getCoder())));
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> openConsumer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec) {
        SerializableFunction consumerFactoryFn = (SerializableFunction)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(spec.getConsumerFactoryFn());
        HashMap<String, Object> consumerConfig = new HashMap<String, Object>();
        consumerConfig.put("bootstrap.servers", org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)spec.getProducerConfig().get("bootstrap.servers")));
        if (spec.getSinkGroupId() != null) {
            consumerConfig.put("group.id", spec.getSinkGroupId());
        }
        consumerConfig.put("key.deserializer", ByteArrayDeserializer.class);
        consumerConfig.put("value.deserializer", ByteArrayDeserializer.class);
        return (Consumer)consumerFactoryFn.apply(consumerConfig);
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Producer<K, V> initializeExactlyOnceProducer( @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec, @UnknownKeyFor @NonNull @Initialized String producerName) {
        HashMap<String, Object> producerConfig = new HashMap<String, Object>(spec.getProducerConfig());
        if (spec.getKeySerializer() != null) {
            producerConfig.put("key.serializer", spec.getKeySerializer());
        }
        if (spec.getValueSerializer() != null) {
            producerConfig.put("value.serializer", spec.getValueSerializer());
        }
        producerConfig.put("enable.idempotence", true);
        producerConfig.put("transactional.id", producerName);
        KafkaProducer producer = spec.getProducerFactoryFn() != null ? (Producer)spec.getProducerFactoryFn().apply(producerConfig) : new KafkaProducer(producerConfig);
        ProducerSpEL.initTransactions(producer);
        return producer;
    }

    private static class ExactlyOnceWriter<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<Integer, Iterable<KV<Long, TimestampedValue<ProducerRecord<K, V>>>>>, Void> {
        private static final @UnknownKeyFor @NonNull @Initialized String NEXT_ID = "nextId";
        private static final @UnknownKeyFor @NonNull @Initialized String MIN_BUFFERED_ID = "minBufferedId";
        private static final @UnknownKeyFor @NonNull @Initialized String OUT_OF_ORDER_BUFFER = "outOfOrderBuffer";
        private static final @UnknownKeyFor @NonNull @Initialized String WRITER_ID = "writerId";
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_RECORDS_PER_TXN = 1000;
        private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper JSON_MAPPER = new ObjectMapper();
        @DoFn.StateId(value="nextId")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long>> sequenceIdSpec = StateSpecs.value();
        @DoFn.StateId(value="minBufferedId")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long>> minBufferedIdSpec = StateSpecs.value();
        @DoFn.StateId(value="outOfOrderBuffer")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V>>>>> outOfOrderBufferSpec;
        @DoFn.StateId(value="writerId")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized String>> writerIdSpec = StateSpecs.value();
        private final  @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec;
        private final @UnknownKeyFor @NonNull @Initialized Counter elementsWritten = SinkMetrics.elementsWritten();
        private final @UnknownKeyFor @NonNull @Initialized Counter elementsBuffered = Metrics.counter((String)"KafkaExactlyOnceSink", (String)"elementsBuffered");
        private final @UnknownKeyFor @NonNull @Initialized Counter numTransactions = Metrics.counter((String)"KafkaExactlyOnceSink", (String)"numTransactions");
        private static final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ShardWriterCache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> CACHE_BY_GROUP_ID = CacheBuilder.newBuilder().build(new CacheLoader<String, ShardWriterCache<?, ?>>(){

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized ShardWriterCache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> load(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized Exception {
                return new ShardWriterCache();
            }
        });

        ExactlyOnceWriter( @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V>> elemCoder) {
            this.spec = spec;
            this.outOfOrderBufferSpec = StateSpecs.bag((Coder)KvCoder.of((Coder)BigEndianLongCoder.of(), (Coder)TimestampedValue.TimestampedValueCoder.of(elemCoder)));
        }

        @DoFn.Setup
        public void setup() {
            KafkaExactlyOnceSink.ensureEOSSupport();
        }

        @DoFn.RequiresStableInput
        @DoFn.ProcessElement
        public void processElement(@DoFn.StateId(value="nextId") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> nextIdState, @DoFn.StateId(value="minBufferedId") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> minBufferedIdState, @DoFn.StateId(value="outOfOrderBuffer") @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V>>>> oooBufferState, @DoFn.StateId(value="writerId") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized String> writerIdState, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) throws @UnknownKeyFor @NonNull @Initialized IOException {
            long committedId;
            int shard = (Integer)((KV)ctx.element()).getKey();
            minBufferedIdState.readLater();
            long nextId = (Long)MoreObjects.firstNonNull((Object)((Long)nextIdState.read()), (Object)0L);
            long minBufferedId = (Long)MoreObjects.firstNonNull((Object)((Long)minBufferedIdState.read()), (Object)Long.MAX_VALUE);
            String sinkGroupId = (String)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.spec.getSinkGroupId());
            ShardWriterCache cache = (ShardWriterCache)CACHE_BY_GROUP_ID.getUnchecked((Object)sinkGroupId);
            ShardWriter writer = cache.removeIfPresent(shard);
            if (writer == null) {
                writer = this.initShardWriter(shard, writerIdState, nextId);
            }
            if ((committedId = writer.committedId) >= nextId) {
                LOG.info("{}: committed id {} is ahead of expected {}. {} records will be dropped (these are already written).", new Object[]{shard, committedId, nextId - 1L, committedId - nextId + 1L});
                nextId = committedId + 1L;
            }
            try {
                writer.beginTxn();
                int txnSize = 0;
                UnmodifiableIterator iter = ((Iterable)((KV)ctx.element()).getValue()).iterator();
                while (iter.hasNext()) {
                    KV kv = (KV)iter.next();
                    long recordId = (Long)kv.getKey();
                    if (recordId < nextId) {
                        LOG.info("{}: dropping older record {}. Already committed till {}", new Object[]{shard, recordId, committedId});
                        continue;
                    }
                    if (recordId > nextId) {
                        LOG.info("{}: Saving out of order record {}, next record id to be written is {}", new Object[]{shard, recordId, nextId});
                        oooBufferState.add((Object)kv);
                        minBufferedId = Math.min(minBufferedId, recordId);
                        minBufferedIdState.write((Object)minBufferedId);
                        this.elementsBuffered.inc();
                        continue;
                    }
                    writer.sendRecord((TimestampedValue)kv.getValue(), this.elementsWritten);
                    ++nextId;
                    if (++txnSize >= 1000) {
                        writer.commitTxn(recordId, this.numTransactions);
                        txnSize = 0;
                        writer.beginTxn();
                    }
                    if (minBufferedId != nextId) continue;
                    ArrayList buffered = Lists.newArrayList((Iterable)oooBufferState.read());
                    buffered.sort(new KV.OrderByKey());
                    LOG.info("{} : merging {} buffered records (min buffered id is {}).", new Object[]{shard, buffered.size(), minBufferedId});
                    oooBufferState.clear();
                    minBufferedIdState.clear();
                    minBufferedId = Long.MAX_VALUE;
                    iter = Iterators.mergeSorted((Iterable)ImmutableList.of(iter, buffered.iterator()), (Comparator)new KV.OrderByKey());
                }
                writer.commitTxn(nextId - 1L, this.numTransactions);
                nextIdState.write((Object)nextId);
            }
            catch (ProducerSpEL.UnrecoverableProducerException e) {
                LOG.warn("{} : closing producer {} after unrecoverable error. The work might have migrated. Committed id {}, current id {}.", new Object[]{writer.shard, writer.producerName, writer.committedId, nextId - 1L, e});
                writer.producer.close();
                writer = null;
                throw e;
            }
            finally {
                if (writer != null) {
                    cache.insert(shard, writer);
                }
            }
        }

        private @UnknownKeyFor @NonNull @Initialized ShardWriter<K, V> initShardWriter(@UnknownKeyFor @NonNull @Initialized int shard, @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized String> writerIdState, @UnknownKeyFor @NonNull @Initialized long nextId) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String producerName = String.format("producer_%d_for_%s", shard, this.spec.getSinkGroupId());
            Producer producer = KafkaExactlyOnceSink.initializeExactlyOnceProducer(this.spec, producerName);
            String topic = (String)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.spec.getTopic());
            try {
                OffsetAndMetadata committed;
                String writerId = (String)writerIdState.read();
                try (Consumer consumer = KafkaExactlyOnceSink.openConsumer(this.spec);){
                    committed = consumer.committed(new TopicPartition(topic, shard));
                }
                long committedSeqId = -1L;
                if (committed == null || committed.metadata() == null || committed.metadata().isEmpty()) {
                    Preconditions.checkState((nextId == 0L && writerId == null ? 1 : 0) != 0, (String)"State exists for shard %s (nextId %s, writerId '%s'), but there is no state stored with Kafka topic '%s' group id '%s'", (Object[])new Object[]{shard, nextId, writerId, this.spec.getTopic(), this.spec.getSinkGroupId()});
                    writerId = String.format("%X - %s", new Random().nextInt(Integer.MAX_VALUE), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZone(DateTimeZone.UTC).print(DateTimeUtils.currentTimeMillis()));
                    writerIdState.write((Object)writerId);
                    LOG.info("Assigned writer id '{}' to shard {}", (Object)writerId, (Object)shard);
                } else {
                    ShardMetadata metadata = (ShardMetadata)JSON_MAPPER.readValue(committed.metadata(), ShardMetadata.class);
                    Preconditions.checkNotNull((Object)metadata.writerId);
                    if (writerId == null) {
                        throw new IllegalStateException(String.format("Kafka metadata exists for shard %s, but there is no stored state for it. This mostly indicates groupId '%s' is used else where or in earlier runs. Try another group id. Metadata for this shard on Kafka : '%s'", shard, this.spec.getSinkGroupId(), committed.metadata()));
                    }
                    Preconditions.checkState((boolean)writerId.equals(metadata.writerId), (String)"Writer ids don't match. This is mostly a unintended misuse of groupId('%s').Beam '%s', Kafka '%s'", (Object)this.spec.getSinkGroupId(), (Object)writerId, (Object)metadata.writerId);
                    committedSeqId = metadata.sequenceId;
                    Preconditions.checkState((committedSeqId >= nextId - 1L ? 1 : 0) != 0, (String)"Committed sequence id can not be lower than %s, partition metadata : %s", (long)(nextId - 1L), (Object)committed.metadata());
                }
                LOG.info("{} : initialized producer {} with committed sequence id {}", new Object[]{shard, producerName, committedSeqId});
                return new ShardWriter<K, V>(shard, writerId, producer, producerName, this.spec, committedSeqId);
            }
            catch (IOException e) {
                producer.close();
                throw e;
            }
        }

        private static class ShardWriterCache<@UnknownKeyFor K, @UnknownKeyFor V> {
            static final @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService SCHEDULED_CLEAN_UP_THREAD = Executors.newSingleThreadScheduledExecutor();
            static final @UnknownKeyFor @NonNull @Initialized int CLEAN_UP_CHECK_INTERVAL_MS = 10000;
            static final @UnknownKeyFor @NonNull @Initialized int IDLE_TIMEOUT_MS = 60000;
            private final @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized ShardWriter<K, V>> cache = CacheBuilder.newBuilder().expireAfterWrite(60000L, TimeUnit.MILLISECONDS).removalListener(notification -> {
                if (notification.getCause() != RemovalCause.EXPLICIT) {
                    ShardWriter writer = (ShardWriter)notification.getValue();
                    LOG.info("{} : Closing idle shard writer {} after 1 minute of idle time.", (Object)writer.shard, (Object)writer.producerName);
                    writer.producer.close();
                }
            }).build();

            ShardWriterCache() {
                SCHEDULED_CLEAN_UP_THREAD.scheduleAtFixedRate(() -> this.cache.cleanUp(), 10000L, 10000L, TimeUnit.MILLISECONDS);
            }

            @Nullable @UnknownKeyFor @Initialized ShardWriter<K, V> removeIfPresent(@UnknownKeyFor @NonNull @Initialized int shard) {
                return (ShardWriter)this.cache.asMap().remove(shard);
            }

            void insert(@UnknownKeyFor @NonNull @Initialized int shard, @UnknownKeyFor @NonNull @Initialized ShardWriter<K, V> writer) {
                ShardWriter<K, V> existing = this.cache.asMap().putIfAbsent(shard, writer);
                Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"Unexpected multiple instances of writers for shard %s", (int)shard);
            }
        }

        private static class ShardWriter<@UnknownKeyFor K, @UnknownKeyFor V> {
            private final @UnknownKeyFor @NonNull @Initialized int shard;
            private final @UnknownKeyFor @NonNull @Initialized String writerId;
            private final @UnknownKeyFor @NonNull @Initialized Producer<K, V> producer;
            private final @UnknownKeyFor @NonNull @Initialized String producerName;
            private final  @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec;
            private @UnknownKeyFor @NonNull @Initialized long committedId;

            ShardWriter(@UnknownKeyFor @NonNull @Initialized int shard, @UnknownKeyFor @NonNull @Initialized String writerId, @UnknownKeyFor @NonNull @Initialized Producer<K, V> producer, @UnknownKeyFor @NonNull @Initialized String producerName,  @UnknownKeyFor @NonNull @Initialized KafkaIO.WriteRecords<K, V> spec, @UnknownKeyFor @NonNull @Initialized long committedId) {
                this.shard = shard;
                this.writerId = writerId;
                this.producer = producer;
                this.producerName = producerName;
                this.spec = spec;
                this.committedId = committedId;
            }

            void beginTxn() {
                ProducerSpEL.beginTransaction(this.producer);
            }

            @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @NonNull @Initialized RecordMetadata> sendRecord(@UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized ProducerRecord<K, V>> record, @UnknownKeyFor @NonNull @Initialized Counter sendCounter) {
                String topic = (String)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.spec.getTopic());
                try {
                    Long timestampMillis = this.spec.getPublishTimestampFunction() != null ? Long.valueOf(this.spec.getPublishTimestampFunction().getTimestamp((ProducerRecord)record.getValue(), record.getTimestamp()).getMillis()) : null;
                    Future result = this.producer.send(new ProducerRecord(topic, null, timestampMillis, ((ProducerRecord)record.getValue()).key(), ((ProducerRecord)record.getValue()).value()));
                    sendCounter.inc();
                    return result;
                }
                catch (KafkaException e) {
                    ProducerSpEL.abortTransaction(this.producer);
                    throw e;
                }
            }

            void commitTxn(@UnknownKeyFor @NonNull @Initialized long lastRecordId, @UnknownKeyFor @NonNull @Initialized Counter numTransactions) throws @UnknownKeyFor @NonNull @Initialized IOException {
                String topic = (String)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.spec.getTopic());
                try {
                    ProducerSpEL.sendOffsetsToTransaction(this.producer, (Map<TopicPartition, OffsetAndMetadata>)ImmutableMap.of((Object)new TopicPartition(topic, this.shard), (Object)new OffsetAndMetadata(0L, JSON_MAPPER.writeValueAsString((Object)new ShardMetadata(lastRecordId, this.writerId)))), this.spec.getSinkGroupId());
                    ProducerSpEL.commitTransaction(this.producer);
                    numTransactions.inc();
                    LOG.debug("{} : committed {} records", (Object)this.shard, (Object)(lastRecordId - this.committedId));
                    this.committedId = lastRecordId;
                }
                catch (KafkaException e) {
                    ProducerSpEL.abortTransaction(this.producer);
                    throw e;
                }
            }
        }

        private static class ShardMetadata {
            @JsonProperty(value="seq")
            public final @UnknownKeyFor @NonNull @Initialized long sequenceId;
            @JsonProperty(value="id")
            public final @Nullable @UnknownKeyFor @Initialized String writerId;

            private ShardMetadata() {
                this.sequenceId = -1L;
                this.writerId = null;
            }

            ShardMetadata(@UnknownKeyFor @NonNull @Initialized long sequenceId, @UnknownKeyFor @NonNull @Initialized String writerId) {
                this.sequenceId = sequenceId;
                this.writerId = writerId;
            }
        }
    }

    private static class Sequencer<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<Integer, Iterable<TimestampedValue<ProducerRecord<K, V>>>>, KV<Integer, KV<Long, TimestampedValue<ProducerRecord<K, V>>>>> {
        private static final @UnknownKeyFor @NonNull @Initialized String NEXT_ID = "nextId";
        @DoFn.StateId(value="nextId")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long>> nextIdSpec = StateSpecs.value();

        private Sequencer() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.StateId(value="nextId") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> nextIdState, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            long nextId = (Long)MoreObjects.firstNonNull((Object)((Long)nextIdState.read()), (Object)0L);
            int shard = (Integer)((KV)ctx.element()).getKey();
            for (TimestampedValue value : (Iterable)((KV)ctx.element()).getValue()) {
                ctx.output((Object)KV.of((Object)shard, (Object)KV.of((Object)nextId, (Object)value)));
                ++nextId;
            }
            nextIdState.write((Object)nextId);
        }
    }

    private static class Reshard<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<ProducerRecord<K, V>, KV<Integer, TimestampedValue<ProducerRecord<K, V>>>> {
        private final @UnknownKeyFor @NonNull @Initialized int numShards;
        private transient @UnknownKeyFor @NonNull @Initialized int shardId;

        Reshard(@UnknownKeyFor @NonNull @Initialized int numShards) {
            this.numShards = numShards;
        }

        @DoFn.Setup
        public void setup() {
            this.shardId = ThreadLocalRandom.current().nextInt(this.numShards);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            this.shardId = (this.shardId + 1) % this.numShards;
            ctx.output((Object)KV.of((Object)this.shardId, (Object)TimestampedValue.of((Object)((ProducerRecord)ctx.element()), (Instant)ctx.timestamp())));
        }
    }
}

