/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.kafka.ConfluentSchemaRegistryDeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoService(value={SchemaTransformProvider.class})
public class KafkaReadSchemaTransformProvider
extends TypedSchemaTransformProvider<KafkaReadSchemaTransformConfiguration> {
    final @UnknownKeyFor @NonNull @Initialized Boolean isTest;
    final @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSecs;

    public KafkaReadSchemaTransformProvider() {
        this(false, 0);
    }

    @VisibleForTesting
    KafkaReadSchemaTransformProvider(@UnknownKeyFor @NonNull @Initialized Boolean isTest, @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSecs) {
        this.isTest = isTest;
        this.testTimeoutSecs = testTimeoutSecs;
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration> configurationClass() {
        return KafkaReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration configuration) {
        return new KafkaReadSchemaTransform(configuration, this.isTest, this.testTimeoutSecs);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:kafka_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Lists.newArrayList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Lists.newArrayList((Object[])new String[]{"output"});
    }

    private static class KafkaReadSchemaTransform
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration configuration;
        private final @UnknownKeyFor @NonNull @Initialized Boolean isTest;
        private final @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSeconds;

        KafkaReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration configuration, @UnknownKeyFor @NonNull @Initialized Boolean isTest, @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSeconds) {
            configuration.validate();
            this.configuration = configuration;
            this.isTest = isTest;
            this.testTimeoutSeconds = testTimeoutSeconds;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            String autoOffsetReset;
            String inputSchema = this.configuration.getSchema();
            final Integer groupId = this.configuration.hashCode() % Integer.MAX_VALUE;
            String string = autoOffsetReset = this.configuration.getAutoOffsetResetConfig() == null ? "latest" : this.configuration.getAutoOffsetResetConfig();
            if (inputSchema != null) {
                assert (this.configuration.getConfluentSchemaRegistryUrl() == null) : "To read from Kafka, a schema must be provided directly or though Confluent Schema Registry, but not both.";
                org.apache.beam.sdk.schemas.Schema beamSchema = Objects.equals(this.configuration.getDataFormat(), "JSON") ? JsonUtils.beamSchemaFromJsonSchema((String)inputSchema) : AvroUtils.toBeamSchema((Schema)new Schema.Parser().parse(inputSchema));
                SimpleFunction valueMapper = Objects.equals(this.configuration.getDataFormat(), "JSON") ? JsonUtils.getJsonBytesToRowFunction((org.apache.beam.sdk.schemas.Schema)beamSchema) : AvroUtils.getAvroBytesToRowFunction((org.apache.beam.sdk.schemas.Schema)beamSchema);
                return new PTransform<PCollectionRowTuple, PCollectionRowTuple>((SerializableFunction)valueMapper, beamSchema){
                    final /* synthetic */ SerializableFunction val$valueMapper;
                    final /* synthetic */ org.apache.beam.sdk.schemas.Schema val$beamSchema;
                    {
                        this.val$valueMapper = serializableFunction;
                        this.val$beamSchema = schema;
                    }

                    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                        KafkaIO.Read<byte[], byte[]> kafkaRead = KafkaIO.readBytes().withConsumerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"group.id", (Object)("kafka-read-provider-" + groupId), (Object)"enable.auto.commit", (Object)true, (Object)"auto.commit.interval.ms", (Object)100, (Object)"auto.offset.reset", (Object)autoOffsetReset)).withTopic(configuration.getTopic()).withBootstrapServers(configuration.getBootstrapServers());
                        if (isTest.booleanValue()) {
                            kafkaRead = kafkaRead.withMaxReadTime(Duration.standardSeconds((long)testTimeoutSeconds.intValue()));
                        }
                        return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)((PCollection)((PCollection)input.getPipeline().apply(kafkaRead.withoutMetadata())).apply((PTransform)Values.create())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via(this.val$valueMapper))).setRowSchema(this.val$beamSchema));
                    }
                };
            }
            return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                    String confluentSchemaRegUrl = configuration.getConfluentSchemaRegistryUrl();
                    String confluentSchemaRegSubject = configuration.getConfluentSchemaRegistrySubject();
                    if (confluentSchemaRegUrl == null || confluentSchemaRegSubject == null) {
                        throw new IllegalArgumentException("To read from Kafka, a schema must be provided directly or though Confluent Schema Registry. Make sure you are providing one of these parameters.");
                    }
                    KafkaIO.Read kafkaRead = KafkaIO.read().withTopic(configuration.getTopic()).withBootstrapServers(configuration.getBootstrapServers()).withConsumerConfigUpdates((Map<String, Object>)ImmutableMap.of((Object)"group.id", (Object)("kafka-read-provider-" + groupId), (Object)"enable.auto.commit", (Object)true, (Object)"auto.commit.interval.ms", (Object)100, (Object)"auto.offset.reset", (Object)autoOffsetReset)).withKeyDeserializer(ByteArrayDeserializer.class).withValueDeserializer(ConfluentSchemaRegistryDeserializerProvider.of(confluentSchemaRegUrl, confluentSchemaRegSubject));
                    if (isTest.booleanValue()) {
                        kafkaRead = kafkaRead.withMaxReadTime(Duration.standardSeconds((long)testTimeoutSeconds.intValue()));
                    }
                    PCollection kafkaValues = (PCollection)((PCollection)input.getPipeline().apply(kafkaRead.withoutMetadata())).apply((PTransform)Values.create());
                    assert (kafkaValues.getCoder().getClass() == AvroCoder.class);
                    AvroCoder coder = (AvroCoder)kafkaValues.getCoder();
                    kafkaValues = kafkaValues.setCoder((Coder)AvroUtils.schemaCoder((Schema)coder.getSchema()));
                    return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)kafkaValues.apply(Convert.toRows())));
                }
            };
        }
    }
}

