/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public class InMemoryObjectReadChannel
extends GoogleCloudStorageReadChannel {
    private final byte[] content;

    public InMemoryObjectReadChannel(String bucketName, String objectName, byte[] content, GoogleCloudStorageReadOptions readOptions) throws IOException {
        super(null, new StorageResourceId(bucketName, objectName), null, null, readOptions);
        this.content = (byte[])Preconditions.checkNotNull((Object)content, (Object)"channelContents could not be null");
    }

    @Override
    @Nullable
    protected GoogleCloudStorageItemInfo getInitialMetadata() throws IOException {
        return null;
    }

    @Override
    protected InputStream openStream(long bytesToRead) throws IOException {
        if (!this.metadataInitialized && this.content.length == 0 && this.currentPosition == 0L) {
            this.setSize(this.content.length);
        } else {
            this.setSize(this.content.length);
            this.validatePosition(this.currentPosition);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.content);
        ((InputStream)inputStream).skip(this.currentPosition);
        this.contentChannelPosition = this.currentPosition;
        return inputStream;
    }
}

