/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.schema.Schema;
import org.apache.commons.lang3.StringUtils;

public class DataResource
implements IResource {
    private static final Set<Permission> TABLE_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.ALTER, (Enum[])new Permission[]{Permission.DROP, Permission.SELECT, Permission.MODIFY, Permission.AUTHORIZE});
    private static final Set<Permission> KEYSPACE_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.CREATE, (Enum[])new Permission[]{Permission.ALTER, Permission.DROP, Permission.SELECT, Permission.MODIFY, Permission.AUTHORIZE});
    private static final String ROOT_NAME = "data";
    private static final DataResource ROOT_RESOURCE = new DataResource(Level.ROOT, null, null);
    private final Level level;
    private final String keyspace;
    private final String table;
    private final transient int hash;

    private DataResource(Level level, String keyspace, String table) {
        this.level = level;
        this.keyspace = keyspace;
        this.table = table;
        this.hash = Objects.hashCode((Object[])new Object[]{level, keyspace, table});
    }

    public static DataResource root() {
        return ROOT_RESOURCE;
    }

    public static DataResource keyspace(String keyspace) {
        return new DataResource(Level.KEYSPACE, keyspace, null);
    }

    public static DataResource table(String keyspace, String table) {
        return new DataResource(Level.TABLE, keyspace, table);
    }

    public static DataResource fromName(String name) {
        String[] parts = StringUtils.split((String)name, (char)'/');
        if (!parts[0].equals(ROOT_NAME) || parts.length > 3) {
            throw new IllegalArgumentException(String.format("%s is not a valid data resource name", name));
        }
        if (parts.length == 1) {
            return DataResource.root();
        }
        if (parts.length == 2) {
            return DataResource.keyspace(parts[1]);
        }
        return DataResource.table(parts[1], parts[2]);
    }

    @Override
    public String getName() {
        switch (this.level) {
            case ROOT: {
                return ROOT_NAME;
            }
            case KEYSPACE: {
                return String.format("%s/%s", ROOT_NAME, this.keyspace);
            }
            case TABLE: {
                return String.format("%s/%s/%s", ROOT_NAME, this.keyspace, this.table);
            }
        }
        throw new AssertionError();
    }

    @Override
    public IResource getParent() {
        switch (this.level) {
            case KEYSPACE: {
                return DataResource.root();
            }
            case TABLE: {
                return DataResource.keyspace(this.keyspace);
            }
        }
        throw new IllegalStateException("Root-level resource can't have a parent");
    }

    public boolean isRootLevel() {
        return this.level == Level.ROOT;
    }

    public boolean isKeyspaceLevel() {
        return this.level == Level.KEYSPACE;
    }

    public boolean isTableLevel() {
        return this.level == Level.TABLE;
    }

    public String getKeyspace() {
        if (this.isRootLevel()) {
            throw new IllegalStateException("ROOT data resource has no keyspace");
        }
        return this.keyspace;
    }

    public String getTable() {
        if (!this.isTableLevel()) {
            throw new IllegalStateException(String.format("%s data resource has no table", new Object[]{this.level}));
        }
        return this.table;
    }

    @Override
    public boolean hasParent() {
        return this.level != Level.ROOT;
    }

    @Override
    public boolean exists() {
        switch (this.level) {
            case ROOT: {
                return true;
            }
            case KEYSPACE: {
                return Schema.instance.getKeyspaces().contains(this.keyspace);
            }
            case TABLE: {
                return Schema.instance.getTableMetadata(this.keyspace, this.table) != null;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Set<Permission> applicablePermissions() {
        switch (this.level) {
            case ROOT: 
            case KEYSPACE: {
                return KEYSPACE_LEVEL_PERMISSIONS;
            }
            case TABLE: {
                return TABLE_LEVEL_PERMISSIONS;
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        switch (this.level) {
            case ROOT: {
                return "<all keyspaces>";
            }
            case KEYSPACE: {
                return String.format("<keyspace %s>", this.keyspace);
            }
            case TABLE: {
                return String.format("<table %s.%s>", this.keyspace, this.table);
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataResource)) {
            return false;
        }
        DataResource ds = (DataResource)o;
        return Objects.equal((Object)((Object)this.level), (Object)((Object)ds.level)) && Objects.equal((Object)this.keyspace, (Object)ds.keyspace) && Objects.equal((Object)this.table, (Object)ds.table);
    }

    public int hashCode() {
        return this.hash;
    }

    static enum Level {
        ROOT,
        KEYSPACE,
        TABLE;

    }
}

