/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public class VariableSpecifications {
    private final List<ColumnIdentifier> variableNames;
    private final List<ColumnSpecification> specs;
    private final ColumnMetadata[] targetColumns;

    public VariableSpecifications(List<ColumnIdentifier> variableNames) {
        this.variableNames = variableNames;
        this.specs = Arrays.asList(new ColumnSpecification[variableNames.size()]);
        this.targetColumns = new ColumnMetadata[variableNames.size()];
    }

    public static VariableSpecifications empty() {
        return new VariableSpecifications(Collections.emptyList());
    }

    public boolean isEmpty() {
        return this.variableNames.isEmpty();
    }

    public List<ColumnSpecification> getBindVariables() {
        return this.specs;
    }

    public short[] getPartitionKeyBindVariableIndexes(TableMetadata metadata) {
        short[] partitionKeyPositions = new short[metadata.partitionKeyColumns().size()];
        boolean[] set = new boolean[partitionKeyPositions.length];
        for (int i = 0; i < this.targetColumns.length; ++i) {
            ColumnMetadata targetColumn = this.targetColumns[i];
            if (targetColumn == null || !targetColumn.isPartitionKey()) continue;
            assert (targetColumn.ksName.equals(metadata.keyspace) && targetColumn.cfName.equals(metadata.name));
            partitionKeyPositions[targetColumn.position()] = (short)i;
            set[targetColumn.position()] = true;
        }
        for (boolean b : set) {
            if (b) continue;
            return null;
        }
        return partitionKeyPositions;
    }

    public void add(int bindIndex, ColumnSpecification spec) {
        ColumnIdentifier bindMarkerName;
        if (spec instanceof ColumnMetadata) {
            this.targetColumns[bindIndex] = (ColumnMetadata)spec;
        }
        if ((bindMarkerName = this.variableNames.get(bindIndex)) != null) {
            spec = new ColumnSpecification(spec.ksName, spec.cfName, bindMarkerName, spec.type);
        }
        this.specs.set(bindIndex, spec);
    }

    public String toString() {
        return this.specs.toString();
    }
}

