/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorWithLowerBound;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.utils.FBUtilities;

public interface StorageHook {
    public static final StorageHook instance = StorageHook.createHook();

    public void reportWrite(TableId var1, PartitionUpdate var2);

    public void reportRead(TableId var1, DecoratedKey var2);

    public UnfilteredRowIteratorWithLowerBound makeRowIteratorWithLowerBound(ColumnFamilyStore var1, DecoratedKey var2, SSTableReader var3, ClusteringIndexFilter var4, ColumnFilter var5, SSTableReadsListener var6);

    public UnfilteredRowIterator makeRowIterator(ColumnFamilyStore var1, SSTableReader var2, DecoratedKey var3, Slices var4, ColumnFilter var5, boolean var6, SSTableReadsListener var7);

    public static StorageHook createHook() {
        String className = System.getProperty("cassandra.storage_hook");
        if (className != null) {
            return (StorageHook)FBUtilities.construct(className, StorageHook.class.getSimpleName());
        }
        return new StorageHook(){

            @Override
            public void reportWrite(TableId tableId, PartitionUpdate partitionUpdate) {
            }

            @Override
            public void reportRead(TableId tableId, DecoratedKey key) {
            }

            @Override
            public UnfilteredRowIteratorWithLowerBound makeRowIteratorWithLowerBound(ColumnFamilyStore cfs, DecoratedKey partitionKey, SSTableReader sstable, ClusteringIndexFilter filter, ColumnFilter selectedColumns, SSTableReadsListener listener) {
                return new UnfilteredRowIteratorWithLowerBound(partitionKey, sstable, filter, selectedColumns, listener);
            }

            @Override
            public UnfilteredRowIterator makeRowIterator(ColumnFamilyStore cfs, SSTableReader sstable, DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
                return sstable.iterator(key, slices, selectedColumns, reversed, listener);
            }
        };
    }
}

