/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.EOFException;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.net.ShareableBytes;

class ChunkedInputPlus
extends RebufferingInputStream {
    private final PeekingIterator<ShareableBytes> iter;

    private ChunkedInputPlus(PeekingIterator<ShareableBytes> iter) {
        super(((ShareableBytes)iter.peek()).get());
        this.iter = iter;
    }

    static ChunkedInputPlus of(Iterable<ShareableBytes> buffers) {
        PeekingIterator iter = Iterators.peekingIterator(buffers.iterator());
        if (!iter.hasNext()) {
            throw new IllegalArgumentException();
        }
        return new ChunkedInputPlus((PeekingIterator<ShareableBytes>)iter);
    }

    @Override
    protected void reBuffer() throws EOFException {
        this.buffer = null;
        ((ShareableBytes)this.iter.peek()).release();
        this.iter.next();
        if (!this.iter.hasNext()) {
            throw new EOFException();
        }
        this.buffer = ((ShareableBytes)this.iter.peek()).get();
    }

    @Override
    public void close() {
        this.buffer = null;
        this.iter.forEachRemaining(ShareableBytes::release);
    }

    int remainder() {
        this.buffer = null;
        int bytes = 0;
        while (this.iter.hasNext()) {
            ShareableBytes chunk = (ShareableBytes)this.iter.peek();
            bytes += chunk.remaining();
            chunk.release();
            this.iter.next();
        }
        return bytes;
    }
}

