/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class PrepareConsistentRequest
extends RepairMessage {
    public final UUID parentSession;
    public final InetAddressAndPort coordinator;
    public final Set<InetAddressAndPort> participants;
    public static final IVersionedSerializer<PrepareConsistentRequest> serializer = new IVersionedSerializer<PrepareConsistentRequest>(){

        @Override
        public void serialize(PrepareConsistentRequest request, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(request.parentSession, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(request.coordinator, out, version);
            out.writeInt(request.participants.size());
            for (InetAddressAndPort peer : request.participants) {
                InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(peer, out, version);
            }
        }

        @Override
        public PrepareConsistentRequest deserialize(DataInputPlus in, int version) throws IOException {
            UUID sessionId = UUIDSerializer.serializer.deserialize(in, version);
            InetAddressAndPort coordinator = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            int numPeers = in.readInt();
            HashSet<InetAddressAndPort> peers = new HashSet<InetAddressAndPort>(numPeers);
            for (int i = 0; i < numPeers; ++i) {
                InetAddressAndPort peer = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
                peers.add(peer);
            }
            return new PrepareConsistentRequest(sessionId, coordinator, peers);
        }

        @Override
        public long serializedSize(PrepareConsistentRequest request, int version) {
            long size = UUIDSerializer.serializer.serializedSize(request.parentSession, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(request.coordinator, version);
            size += (long)TypeSizes.sizeof(request.participants.size());
            for (InetAddressAndPort peer : request.participants) {
                size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(peer, version);
            }
            return size;
        }
    };

    public PrepareConsistentRequest(UUID parentSession, InetAddressAndPort coordinator, Set<InetAddressAndPort> participants) {
        super(null);
        assert (parentSession != null);
        assert (coordinator != null);
        assert (participants != null && !participants.isEmpty());
        this.parentSession = parentSession;
        this.coordinator = coordinator;
        this.participants = ImmutableSet.copyOf(participants);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepareConsistentRequest that = (PrepareConsistentRequest)o;
        if (!this.parentSession.equals(that.parentSession)) {
            return false;
        }
        if (!this.coordinator.equals(that.coordinator)) {
            return false;
        }
        return this.participants.equals(that.participants);
    }

    public int hashCode() {
        int result = this.parentSession.hashCode();
        result = 31 * result + this.coordinator.hashCode();
        result = 31 * result + this.participants.hashCode();
        return result;
    }

    public String toString() {
        return "PrepareConsistentRequest{parentSession=" + this.parentSession + ", coordinator=" + this.coordinator + ", participants=" + this.participants + '}';
    }
}

