/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;

public class BatchlogResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    AbstractWriteResponseHandler<T> wrapped;
    BatchlogCleanup cleanup;
    protected volatile int requiredBeforeFinish;
    private static final AtomicIntegerFieldUpdater<BatchlogResponseHandler> requiredBeforeFinishUpdater = AtomicIntegerFieldUpdater.newUpdater(BatchlogResponseHandler.class, "requiredBeforeFinish");

    public BatchlogResponseHandler(AbstractWriteResponseHandler<T> wrapped, int requiredBeforeFinish, BatchlogCleanup cleanup, long queryStartNanoTime) {
        super(wrapped.replicaPlan, wrapped.callback, wrapped.writeType, queryStartNanoTime);
        this.wrapped = wrapped;
        this.requiredBeforeFinish = requiredBeforeFinish;
        this.cleanup = cleanup;
    }

    @Override
    protected int ackCount() {
        return this.wrapped.ackCount();
    }

    @Override
    public void onResponse(Message<T> msg) {
        this.wrapped.onResponse(msg);
        if (requiredBeforeFinishUpdater.decrementAndGet(this) == 0) {
            this.cleanup.ackMutation();
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        this.wrapped.onFailure(from, failureReason);
    }

    @Override
    public boolean invokeOnFailure() {
        return this.wrapped.invokeOnFailure();
    }

    @Override
    public void get() throws WriteTimeoutException, WriteFailureException {
        this.wrapped.get();
    }

    @Override
    protected int blockFor() {
        return this.wrapped.blockFor();
    }

    @Override
    protected int candidateReplicaCount() {
        return this.wrapped.candidateReplicaCount();
    }

    @Override
    protected boolean waitingFor(InetAddressAndPort from) {
        return this.wrapped.waitingFor(from);
    }

    @Override
    protected void signal() {
        this.wrapped.signal();
    }

    public static interface BatchlogCleanupCallback {
        public void invoke();
    }

    public static class BatchlogCleanup {
        private final BatchlogCleanupCallback callback;
        protected volatile int mutationsWaitingFor;
        private static final AtomicIntegerFieldUpdater<BatchlogCleanup> mutationsWaitingForUpdater = AtomicIntegerFieldUpdater.newUpdater(BatchlogCleanup.class, "mutationsWaitingFor");

        public BatchlogCleanup(int mutationsWaitingFor, BatchlogCleanupCallback callback) {
            this.mutationsWaitingFor = mutationsWaitingFor;
            this.callback = callback;
        }

        public int decrement() {
            return mutationsWaitingForUpdater.decrementAndGet(this);
        }

        public void ackMutation() {
            if (this.decrement() == 0) {
                this.callback.invoke();
            }
        }
    }
}

