/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.function.Predicate;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.locator.InOurDcTester;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.WriteResponseHandler;

public class DatacenterWriteResponseHandler<T>
extends WriteResponseHandler<T> {
    private final Predicate<InetAddressAndPort> waitingFor = InOurDcTester.endpoints();

    public DatacenterWriteResponseHandler(ReplicaPlan.ForTokenWrite replicaPlan, Runnable callback, WriteType writeType, long queryStartNanoTime) {
        super(replicaPlan, callback, writeType, queryStartNanoTime);
        assert (replicaPlan.consistencyLevel().isDatacenterLocal());
    }

    @Override
    public void onResponse(Message<T> message) {
        if (message == null || this.waitingFor(message.from())) {
            super.onResponse(message);
        } else {
            this.logResponseToIdealCLDelegate(message);
        }
    }

    @Override
    protected boolean waitingFor(InetAddressAndPort from) {
        return this.waitingFor.test(from);
    }
}

