/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class TransferFolderArg {
    protected final String sharedFolderId;
    protected final String toDropboxId;

    public TransferFolderArg(String sharedFolderId, String toDropboxId) {
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        if (toDropboxId == null) {
            throw new IllegalArgumentException("Required value for 'toDropboxId' is null");
        }
        if (toDropboxId.length() < 1) {
            throw new IllegalArgumentException("String 'toDropboxId' is shorter than 1");
        }
        this.toDropboxId = toDropboxId;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public String getToDropboxId() {
        return this.toDropboxId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedFolderId, this.toDropboxId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TransferFolderArg other = (TransferFolderArg)obj;
            return !(this.sharedFolderId != other.sharedFolderId && !this.sharedFolderId.equals(other.sharedFolderId) || this.toDropboxId != other.toDropboxId && !this.toDropboxId.equals(other.toDropboxId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TransferFolderArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TransferFolderArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("shared_folder_id");
            StoneSerializers.string().serialize(value.sharedFolderId, g);
            g.writeFieldName("to_dropbox_id");
            StoneSerializers.string().serialize(value.toDropboxId, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TransferFolderArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_toDropboxId;
            String f_sharedFolderId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sharedFolderId = null;
                f_toDropboxId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("to_dropbox_id".equals(field)) {
                        f_toDropboxId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sharedFolderId == null) {
                    throw new JsonParseException(p, "Required field \"shared_folder_id\" missing.");
                }
                if (f_toDropboxId == null) {
                    throw new JsonParseException(p, "Required field \"to_dropbox_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TransferFolderArg value = new TransferFolderArg(f_sharedFolderId, f_toDropboxId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

