/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.PrimaryTeamRequestReminderDetails;
import com.dropbox.core.v2.teamlog.SecondaryTeamRequestReminderDetails;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TeamMergeRequestReminderExtraDetails {
    public static final TeamMergeRequestReminderExtraDetails OTHER = new TeamMergeRequestReminderExtraDetails().withTag(Tag.OTHER);
    private Tag _tag;
    private PrimaryTeamRequestReminderDetails primaryTeamValue;
    private SecondaryTeamRequestReminderDetails secondaryTeamValue;

    private TeamMergeRequestReminderExtraDetails() {
    }

    private TeamMergeRequestReminderExtraDetails withTag(Tag _tag) {
        TeamMergeRequestReminderExtraDetails result = new TeamMergeRequestReminderExtraDetails();
        result._tag = _tag;
        return result;
    }

    private TeamMergeRequestReminderExtraDetails withTagAndPrimaryTeam(Tag _tag, PrimaryTeamRequestReminderDetails primaryTeamValue) {
        TeamMergeRequestReminderExtraDetails result = new TeamMergeRequestReminderExtraDetails();
        result._tag = _tag;
        result.primaryTeamValue = primaryTeamValue;
        return result;
    }

    private TeamMergeRequestReminderExtraDetails withTagAndSecondaryTeam(Tag _tag, SecondaryTeamRequestReminderDetails secondaryTeamValue) {
        TeamMergeRequestReminderExtraDetails result = new TeamMergeRequestReminderExtraDetails();
        result._tag = _tag;
        result.secondaryTeamValue = secondaryTeamValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPrimaryTeam() {
        return this._tag == Tag.PRIMARY_TEAM;
    }

    public static TeamMergeRequestReminderExtraDetails primaryTeam(PrimaryTeamRequestReminderDetails value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamMergeRequestReminderExtraDetails().withTagAndPrimaryTeam(Tag.PRIMARY_TEAM, value);
    }

    public PrimaryTeamRequestReminderDetails getPrimaryTeamValue() {
        if (this._tag != Tag.PRIMARY_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.PRIMARY_TEAM, but was Tag." + this._tag.name());
        }
        return this.primaryTeamValue;
    }

    public boolean isSecondaryTeam() {
        return this._tag == Tag.SECONDARY_TEAM;
    }

    public static TeamMergeRequestReminderExtraDetails secondaryTeam(SecondaryTeamRequestReminderDetails value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TeamMergeRequestReminderExtraDetails().withTagAndSecondaryTeam(Tag.SECONDARY_TEAM, value);
    }

    public SecondaryTeamRequestReminderDetails getSecondaryTeamValue() {
        if (this._tag != Tag.SECONDARY_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.SECONDARY_TEAM, but was Tag." + this._tag.name());
        }
        return this.secondaryTeamValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.primaryTeamValue, this.secondaryTeamValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TeamMergeRequestReminderExtraDetails) {
            TeamMergeRequestReminderExtraDetails other = (TeamMergeRequestReminderExtraDetails)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PRIMARY_TEAM: {
                    return this.primaryTeamValue == other.primaryTeamValue || this.primaryTeamValue.equals(other.primaryTeamValue);
                }
                case SECONDARY_TEAM: {
                    return this.secondaryTeamValue == other.secondaryTeamValue || this.secondaryTeamValue.equals(other.secondaryTeamValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TeamMergeRequestReminderExtraDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMergeRequestReminderExtraDetails value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PRIMARY_TEAM: {
                    g.writeStartObject();
                    this.writeTag("primary_team", g);
                    PrimaryTeamRequestReminderDetails.Serializer.INSTANCE.serialize(value.primaryTeamValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case SECONDARY_TEAM: {
                    g.writeStartObject();
                    this.writeTag("secondary_team", g);
                    SecondaryTeamRequestReminderDetails.Serializer.INSTANCE.serialize(value.secondaryTeamValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public TeamMergeRequestReminderExtraDetails deserialize(JsonParser p) throws IOException, JsonParseException {
            TeamMergeRequestReminderExtraDetails value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("primary_team".equals(tag)) {
                PrimaryTeamRequestReminderDetails fieldValue = null;
                fieldValue = PrimaryTeamRequestReminderDetails.Serializer.INSTANCE.deserialize(p, true);
                value = TeamMergeRequestReminderExtraDetails.primaryTeam(fieldValue);
            } else if ("secondary_team".equals(tag)) {
                SecondaryTeamRequestReminderDetails fieldValue = null;
                fieldValue = SecondaryTeamRequestReminderDetails.Serializer.INSTANCE.deserialize(p, true);
                value = TeamMergeRequestReminderExtraDetails.secondaryTeam(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PRIMARY_TEAM,
        SECONDARY_TEAM,
        OTHER;

    }
}

