/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiFunction;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.bigquery.BigQueryError;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobStatus
implements Serializable {
    private static final long serialVersionUID = -714976456815445365L;
    private final State state;
    private final BigQueryError error;
    private final List<BigQueryError> executionErrors;

    JobStatus(State state) {
        this.state = state;
        this.error = null;
        this.executionErrors = null;
    }

    JobStatus(State state, BigQueryError error, List<BigQueryError> executionErrors) {
        this.state = state;
        this.error = error;
        this.executionErrors = executionErrors != null ? ImmutableList.copyOf(executionErrors) : null;
    }

    public State getState() {
        return this.state;
    }

    @Nullable
    public BigQueryError getError() {
        return this.error;
    }

    public List<BigQueryError> getExecutionErrors() {
        return this.executionErrors;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("error", (Object)this.error).add("executionErrors", this.executionErrors).toString();
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.state, this.error, this.executionErrors});
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(JobStatus.class) && Objects.equals(this.toPb(), ((JobStatus)obj).toPb());
    }

    com.google.api.services.bigquery.model.JobStatus toPb() {
        com.google.api.services.bigquery.model.JobStatus statusPb = new com.google.api.services.bigquery.model.JobStatus();
        if (this.state != null) {
            statusPb.setState(this.state.toString());
        }
        if (this.error != null) {
            statusPb.setErrorResult(this.error.toPb());
        }
        if (this.executionErrors != null) {
            statusPb.setErrors(Lists.transform(this.executionErrors, BigQueryError.TO_PB_FUNCTION));
        }
        return statusPb;
    }

    static JobStatus fromPb(com.google.api.services.bigquery.model.JobStatus statusPb) {
        List allErrors = null;
        if (statusPb.getErrors() != null) {
            allErrors = Lists.transform((List)statusPb.getErrors(), BigQueryError.FROM_PB_FUNCTION);
        }
        BigQueryError error = statusPb.getErrorResult() != null ? BigQueryError.fromPb(statusPb.getErrorResult()) : null;
        return new JobStatus(State.valueOf(statusPb.getState()), error, allErrors);
    }

    public static final class State
    extends StringEnumValue {
        private static final long serialVersionUID = 818920627219751204L;
        private static final ApiFunction<String, State> CONSTRUCTOR = new ApiFunction<String, State>(){

            public State apply(String constant) {
                return new State(constant);
            }
        };
        private static final StringEnumType<State> type = new StringEnumType(State.class, CONSTRUCTOR);
        public static final State PENDING = (State)((Object)type.createAndRegister("PENDING"));
        public static final State RUNNING = (State)((Object)type.createAndRegister("RUNNING"));
        public static final State DONE = (State)((Object)type.createAndRegister("DONE"));

        private State(String constant) {
            super(constant);
        }

        public static State valueOfStrict(String constant) {
            return (State)((Object)type.valueOfStrict(constant));
        }

        public static State valueOf(String constant) {
            return (State)((Object)type.valueOf(constant));
        }

        public static State[] values() {
            return (State[])type.values();
        }
    }
}

