/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.ClassUtils;
import org.apache.hop.core.logging.ILogChannel;
import org.eclipse.swt.widgets.Display;

public class DisplayInvocationHandler<T>
implements InvocationHandler {
    private final Display display;
    private final T delegate;
    private final ILogChannel log;
    private final boolean asyncForVoid;

    public static <T> T forObject(Class<T> iface, T delegate, Display display, ILogChannel log, boolean asyncForVoid) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), ClassUtils.getAllInterfaces(delegate.getClass()).toArray(new Class[0]), new DisplayInvocationHandler<T>(display, delegate, log, asyncForVoid));
    }

    public DisplayInvocationHandler(Display display, T delegate, ILogChannel log, boolean asyncForVoid) {
        this.display = display;
        this.delegate = delegate;
        this.log = log;
        this.asyncForVoid = asyncForVoid;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.display.getThread() == Thread.currentThread()) {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        if (this.asyncForVoid && method.getReturnType().equals(Void.TYPE)) {
            this.display.asyncExec(() -> {
                try {
                    method.invoke(this.delegate, args);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    this.log.logError(e.getMessage(), e);
                }
            });
            return null;
        }
        ResultHolder resultHolder = new ResultHolder();
        this.display.syncExec(() -> {
            try {
                resultHolder.result = method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException e) {
                resultHolder.throwable = e.getCause();
            }
            catch (Exception e) {
                resultHolder.throwable = e;
            }
        });
        if (resultHolder.result != null) {
            return resultHolder.result;
        }
        throw resultHolder.throwable;
    }

    private class ResultHolder {
        private volatile Throwable throwable = null;
        private volatile Object result = null;

        private ResultHolder() {
        }
    }
}

