/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.JavaPlatform;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.Platform;
import net.sf.saxon.SourceResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ExtensionFunctionFactory;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.StandardCollectionURIResolver;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.instruct.Debugger;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentNumberAllocator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.StandardModuleURIResolver;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.sort.StandardCollationURIResolver;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaURIResolver;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Configuration
implements Serializable,
SourceResolver {
    private Platform platform = JavaPlatform.getInstance();
    private transient URIResolver uriResolver;
    private StandardURIResolver systemURIResolver = new StandardURIResolver(this);
    protected transient ErrorListener listener;
    private int xmlVersion = 10;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private FunctionLibrary extensionBinder;
    private CollationURIResolver collationResolver = StandardCollationURIResolver.getInstance();
    private CollectionURIResolver collectionResolver = new StandardCollectionURIResolver();
    private ModuleURIResolver moduleURIResolver = null;
    private ModuleURIResolver standardModuleURIResolver = new StandardModuleURIResolver(this);
    private SchemaURIResolver schemaURIResolver = null;
    private SourceResolver sourceResolver = this;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    protected int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean versionWarning = true;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private boolean allNodesUntyped = false;
    private boolean lazyConstructionMode = false;
    private boolean allowMultiThreading = false;
    private int stripsWhiteSpace = 11;
    private NamePool targetNamePool = null;
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private XPathContext conversionContext = null;
    private int hostLanguage = 50;
    private int schemaValidationMode = 3;
    private boolean validationWarnings = false;
    private boolean retainDTDattributeTypes = false;
    private Debugger debugger = null;
    protected Optimizer optimizer = null;
    private ExtensionFunctionFactory extensionFunctionFactory = new ExtensionFunctionFactory(this);
    private transient ClassLoader classLoader;
    private int implicitTimezone;
    private transient List sourceParserPool = new ArrayList(5);
    private transient List styleParserPool = new ArrayList(5);
    private static List sharedExternalObjectModels = null;
    private List externalObjectModels = null;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;
    static /* synthetic */ Class class$net$sf$saxon$Configuration;

    public Configuration() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Serializable serializable;
        if (System.getProperty("java.vendor").equals("Jeroen Frijters")) {
            try {
                this.setPlatform((Platform)this.getInstance("net.sf.saxon.dotnet.DotNetPlatform", null));
                this.platform.initialize(this);
            }
            catch (XPathException xPathException) {
                throw new RuntimeException("Failed to load .NET platform code");
            }
            this.externalObjectModels = Collections.EMPTY_LIST;
        } else {
            serializable = class$net$sf$saxon$Configuration == null ? (class$net$sf$saxon$Configuration = Configuration.class$("net.sf.saxon.Configuration")) : class$net$sf$saxon$Configuration;
            synchronized (serializable) {
                if (sharedExternalObjectModels == null) {
                    this.registerStandardObjectModels();
                }
                this.externalObjectModels = new ArrayList(sharedExternalObjectModels);
            }
        }
        this.targetNamePool = NamePool.getDefaultNamePool();
        this.extensionBinder = new JavaExtensionLibrary(this);
        serializable = new GregorianCalendar();
        int n = ((Calendar)serializable).get(15) + ((Calendar)serializable).get(16);
        this.implicitTimezone = n / 60000;
    }

    public static Configuration makeSchemaAwareConfiguration(ClassLoader classLoader) throws RuntimeException {
        try {
            Class<?> clazz;
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 == null) {
                try {
                    classLoader2 = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception exception) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (classLoader2 != null) {
                try {
                    clazz = classLoader2.loadClass("com.saxonica.validate.SchemaAwareConfiguration");
                }
                catch (Exception exception) {
                    clazz = Class.forName("com.saxonica.validate.SchemaAwareConfiguration");
                }
            } else {
                clazz = Class.forName("com.saxonica.validate.SchemaAwareConfiguration");
            }
            Configuration configuration = (Configuration)clazz.newInstance();
            configuration.init();
            return configuration;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public String getProductTitle() {
        return "Saxon " + Version.getProductVersion() + this.platform.getPlatformSuffix() + " from Saxonica";
    }

    public boolean isSchemaAware(int n) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public URIResolver getURIResolver() {
        if (this.uriResolver == null) {
            return this.systemURIResolver;
        }
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.systemURIResolver;
    }

    public URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = this.getInstance(string, null);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new DynamicError("Class " + string + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
            ((StandardErrorListener)this.listener).setRecoveryPolicy(this.recoveryPolicy);
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.listener = errorListener;
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            xPathException.setHasBeenReported();
        }
    }

    public void setMultiThreading(boolean bl) {
        this.allowMultiThreading = bl;
    }

    public boolean isMultiThreading() {
        return this.allowMultiThreading;
    }

    public void setXMLVersion(int n) {
        this.xmlVersion = n;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public NameChecker getNameChecker() {
        return this.xmlVersion == 10 ? Name10Checker.getInstance() : Name11Checker.getInstance();
    }

    public XPathContext getConversionContext() {
        if (this.conversionContext == null) {
            this.conversionContext = new IndependentContext(this).makeEarlyEvaluationContext();
        }
        return this.conversionContext;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setMultiThreading(false);
    }

    public TraceListener makeTraceListener(String string) throws XPathException {
        Object object = this.getInstance(string, null);
        if (object instanceof TraceListener) {
            return (TraceListener)object;
        }
        throw new DynamicError("Class " + string + " is not a TraceListener");
    }

    public void setExtensionBinder(FunctionLibrary functionLibrary) {
        this.extensionBinder = functionLibrary;
    }

    public FunctionLibrary getExtensionBinder() {
        return this.extensionBinder;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public void setCollationURIResolver(CollationURIResolver collationURIResolver) {
        this.collationResolver = collationURIResolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver collectionURIResolver) {
        this.collectionResolver = collectionURIResolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public void setModuleURIResolver(String string) throws TransformerException {
        Object object = this.getInstance(string, null);
        if (!(object instanceof ModuleURIResolver)) {
            throw new DynamicError("Class " + string + " is not a LocationHintResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)object);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver schemaURIResolver) {
        this.schemaURIResolver = schemaURIResolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String string) {
        this.messageEmitterClass = string;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String string) {
        this.sourceParserClass = string;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String string) {
        this.styleParserClass = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean bl) {
        this.versionWarning = bl;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean bl) {
        this.allowExternalFunctions = bl;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setRetainDTDAttributeTypes(boolean bl) throws TransformerFactoryConfigurationError {
        if (bl && !this.isSchemaAware(52)) {
            throw new TransformerFactoryConfigurationError("Retaining DTD attribute types requires the schema-aware product");
        }
        this.retainDTDattributeTypes = bl;
    }

    public boolean isRetainDTDAttributeTypes() {
        return this.retainDTDattributeTypes;
    }

    public void setTraceExternalFunctions(boolean bl) {
        this.traceExternalFunctions = bl;
    }

    public ExtensionFunctionFactory getExtensionFunctionFactory() {
        return this.extensionFunctionFactory;
    }

    public void setExtensionFunctionFactory(ExtensionFunctionFactory extensionFunctionFactory) {
        this.extensionFunctionFactory = extensionFunctionFactory;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean bl) {
        this.validation = bl;
    }

    public void setAllNodesUntyped(boolean bl) {
        this.allNodesUntyped = bl;
    }

    public boolean areAllNodesUntyped() {
        return this.allNodesUntyped;
    }

    public int getSchemaValidationMode() {
        return this.schemaValidationMode;
    }

    public void setSchemaValidationMode(int n) {
        switch (n) {
            case 3: 
            case 4: {
                break;
            }
            case 1: 
            case 2: {
                if (this.isSchemaAware(52)) break;
                this.needSchemaAwareVersion();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + n);
            }
        }
        this.schemaValidationMode = n;
    }

    public void setValidationWarnings(boolean bl) {
        this.validationWarnings = bl;
    }

    public boolean isValidationWarnings() {
        return this.validationWarnings;
    }

    public NamePool getNamePool() {
        return this.targetNamePool;
    }

    public void setNamePool(NamePool namePool) {
        this.targetNamePool = namePool;
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsWhiteSpace == 12;
    }

    public void setStripsAllWhiteSpace(boolean bl) {
        if (bl) {
            this.stripsWhiteSpace = 12;
        }
    }

    public void setStripsWhiteSpace(int n) {
        this.stripsWhiteSpace = n;
    }

    public int getStripsWhiteSpace() {
        return this.stripsWhiteSpace;
    }

    public synchronized XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList(10);
        }
        if (this.sourceParserPool.size() > 0) {
            int n = this.sourceParserPool.size() - 1;
            XMLReader xMLReader = (XMLReader)this.sourceParserPool.get(n);
            this.sourceParserPool.remove(n);
            return xMLReader;
        }
        XMLReader xMLReader = this.getSourceParserClass() != null ? this.makeParser(this.getSourceParserClass()) : this.loadParser();
        try {
            Sender.configureParser(xMLReader);
        }
        catch (DynamicError dynamicError) {
            throw new TransformerFactoryConfigurationError(dynamicError);
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    public synchronized void reuseSourceParser(XMLReader xMLReader) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList(10);
        }
        this.sourceParserPool.add(xMLReader);
    }

    private XMLReader loadParser() {
        XMLReader xMLReader;
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformerFactoryConfigurationError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new TransformerFactoryConfigurationError(sAXException);
        }
        return xMLReader;
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList(10);
        }
        if (this.styleParserPool.size() > 0) {
            int n = this.styleParserPool.size() - 1;
            XMLReader xMLReader = (XMLReader)this.styleParserPool.get(n);
            this.styleParserPool.remove(n);
            return xMLReader;
        }
        XMLReader xMLReader = this.getStyleParserClass() != null ? this.makeParser(this.getStyleParserClass()) : this.loadParser();
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerFactoryConfigurationError(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerFactoryConfigurationError(sAXNotSupportedException);
        }
        return xMLReader;
    }

    public synchronized void reuseStyleParser(XMLReader xMLReader) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList(10);
        }
        this.styleParserPool.add(xMLReader);
    }

    public String readSchema(PipelineConfiguration pipelineConfiguration, String string, String string2, String string3) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipelineConfiguration, String string, List list, String string2) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public String readInlineSchema(NodeInfo nodeInfo, String string) throws SchemaException {
        this.needSchemaAwareVersion();
        return null;
    }

    private void needSchemaAwareVersion() {
        throw new UnsupportedOperationException("You need the schema-aware version of Saxon for this operation");
    }

    public void addSchemaSource(Source source) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public void addSchema(Object object) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
    }

    public Object getSchema(String string) {
        return null;
    }

    public Set getImportedNamespaces() {
        return Collections.EMPTY_SET;
    }

    public void sealNamespace(String string) {
    }

    public boolean isSealedNamespace(String string) {
        return false;
    }

    public SchemaDeclaration getElementDeclaration(int n) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int n) {
        return null;
    }

    public SchemaType getSchemaType(int n) {
        if (n < 1023) {
            return BuiltInSchemaFactory.getSchemaType(n);
        }
        return null;
    }

    public Receiver getDocumentValidator(Receiver receiver, String string, NamePool namePool, int n, int n2, SchemaType schemaType) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, int n, int n2, SchemaType schemaType, int n3, NamePool namePool) throws XPathException {
        return receiver;
    }

    public int validateAttribute(int n, CharSequence charSequence, int n2) throws ValidationException {
        return -1;
    }

    public Receiver getAnnotationStripper(Receiver receiver) {
        return receiver;
    }

    public NodeTest makeSubstitutionGroupTest(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = this.getInstance(string, null);
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError(xPathException);
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
        }
        return this.optimizer;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getClass(String string, boolean bl, ClassLoader classLoader) throws XPathException {
        if (bl) {
            System.err.println("Loading " + string);
        }
        try {
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 == null) {
                classLoader2 = this.classLoader;
            }
            if (classLoader2 == null) {
                classLoader2 = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader2 != null) {
                try {
                    return classLoader2.loadClass(string);
                }
                catch (Exception exception) {
                    return Class.forName(string);
                }
            }
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (bl) {
                System.err.println("No Java class " + string + " could be loaded");
            }
            throw new DynamicError("Failed to load " + string, exception);
        }
    }

    public Object getInstance(String string, ClassLoader classLoader) throws XPathException {
        Class clazz = this.getClass(string, false, classLoader);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new DynamicError("Failed to instantiate class " + string, exception);
        }
    }

    public Comparator makeCollator(String string) throws XPathException {
        Object object = this.getInstance(string, null);
        if (object instanceof Comparator) {
            return (Comparator)object;
        }
        throw new DynamicError("Failed to load collation class " + string + ": it is not an instance of java.util.Comparator");
    }

    public void setLazyConstructionMode(boolean bl) {
        this.lazyConstructionMode = bl;
    }

    public boolean isLazyConstructionMode() {
        return this.lazyConstructionMode;
    }

    private void registerStandardObjectModels() {
        String[] stringArray = new String[]{"net.sf.saxon.dom.DOMEnvelope", "net.sf.saxon.dom.DOMObjectModel", "net.sf.saxon.jdom.JDOMObjectModel", "net.sf.saxon.xom.XOMObjectModel"};
        String[] stringArray2 = new String[]{"net.sf.saxon.dom.NodeOverNodeInfo", "org.w3c.dom.Node", "org.jdom.Element", "nu.xom.Node"};
        sharedExternalObjectModels = new ArrayList(4);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.getClass(stringArray2[i], false, null);
                ExternalObjectModel externalObjectModel = (ExternalObjectModel)this.getInstance(stringArray[i], null);
                sharedExternalObjectModels.add(externalObjectModel);
                continue;
            }
            catch (XPathException xPathException) {
                continue;
            }
            catch (ClassCastException classCastException) {
                System.err.println("Warning: external object model " + stringArray[i] + " has been loaded, but is not an instance of net.sf.saxon.om.ExternalObjectModel");
                continue;
            }
            catch (Throwable throwable) {
                System.err.println("Warning: failed to load external object model: " + throwable.getMessage());
            }
        }
    }

    public void registerExternalObjectModel(ExternalObjectModel externalObjectModel) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList(4);
        }
        if (!this.externalObjectModels.contains(externalObjectModel)) {
            this.externalObjectModels.add(externalObjectModel);
        }
    }

    public ExternalObjectModel findExternalObjectModel(Object object) {
        if (this.externalObjectModels == null) {
            return null;
        }
        Iterator iterator = this.externalObjectModels.iterator();
        while (iterator.hasNext()) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)iterator.next();
            if (!externalObjectModel.isRecognizedNode(object)) continue;
            return externalObjectModel;
        }
        return null;
    }

    public List getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = new PipelineConfiguration();
        pipelineConfiguration.setConfiguration(this);
        pipelineConfiguration.setErrorListener(this.getErrorListener());
        pipelineConfiguration.setURIResolver(this.getURIResolver());
        pipelineConfiguration.setSchemaURIResolver(this.getSchemaURIResolver());
        return pipelineConfiguration;
    }

    public void setImplicitTimezone(int n) {
        if (n < -840 || n > 840) {
            throw new IllegalArgumentException("Implicit timezone is out of range: range is -840 to +840 minutes");
        }
        this.implicitTimezone = n;
    }

    public int getImplicitTimezone() {
        return this.implicitTimezone;
    }

    public static Configuration getConfiguration(XPathContext xPathContext) {
        return xPathContext.getConfiguration();
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public Source resolveSource(Source source, Configuration configuration) throws XPathException {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullProvider) {
            return source;
        }
        return null;
    }

    public Receiver getOutputMethod(String string) {
        return null;
    }

    public void setConfigurationProperty(String string, Object object) {
        Configuration configuration = this;
        if (string.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            configuration.setTreeModel((Integer)object);
        } else if (string.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("ALLOW_EXTERNAL_FUNCTIONS must be a boolean");
            }
            configuration.setAllowExternalFunctions((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("RECOGNIZE_QUERY_URI_PARAMETERS must be a boolean");
            }
            configuration.getSystemURIResolver().setRecognizeQueryParameters((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("TRACE_EXTERNAL_FUNCTIONS must be a boolean");
            }
            configuration.setTraceExternalFunctions((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/timing")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("TIMING must be a boolean");
            }
            configuration.setTiming((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/validation")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("DTD_VALIDATION must be a boolean");
            }
            configuration.setValidation((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int n;
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("STRIP_WHITESPACE must be a string");
            }
            if (object.equals("all")) {
                n = 12;
            } else if (object.equals("none")) {
                n = 10;
            } else if (object.equals("ignorable")) {
                n = 11;
            } else {
                throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + object + "': must be 'all', 'none', or 'ignorable'");
            }
            configuration.setStripsWhiteSpace(n);
        } else if (string.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION must be an integer");
            }
            configuration.setSchemaValidationMode((Integer)object);
        } else if (string.equals("http://saxon.sf.net/feature/validation-warnings")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("VALIDATION_WARNINGS must be a boolean");
            }
            configuration.setValidationWarnings((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/version-warning")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("VERSION_WARNING must be a boolean");
            }
            configuration.setVersionWarning((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(object instanceof TraceListener)) {
                throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
            }
            configuration.setTraceListener((TraceListener)object);
        } else if (string.equals("http://saxon.sf.net/feature/linenumbering")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("LINE_NUMBERING value must be Boolean");
            }
            configuration.setLineNumbering((Boolean)object);
        } else if (string.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("RECOVERY_POLICY value must be Integer");
            }
            configuration.setRecoveryPolicy((Integer)object);
        } else if (string.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("MESSAGE_EMITTER class must be a String");
            }
            configuration.setMessageEmitterClass((String)object);
        } else if (string.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("SOURCE_PARSER class must be a String");
            }
            configuration.setSourceParserClass((String)object);
        } else if (string.equals("http://saxon.sf.net/feature/styleParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("STYLE_PARSER class must be a String");
            }
            configuration.setStyleParserClass((String)object);
        } else if (string.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(object instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.OutputURIResolver");
            }
            configuration.setOutputURIResolver((OutputURIResolver)object);
        } else if (string.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(object instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
            }
            configuration.setNamePool((NamePool)object);
        } else if (string.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            if (!(object instanceof CollationURIResolver)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.sort.CollationURIResolver");
            }
            configuration.setCollationURIResolver((CollationURIResolver)object);
        } else if (string.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            if (!(object instanceof CollectionURIResolver)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net.sf.saxon.CollectionURIResolver");
            }
            configuration.setCollectionURIResolver((CollectionURIResolver)object);
        } else if (string.equals("http://saxon.sf.bet/feature/xml-version")) {
            if (!(object instanceof String) || !object.equals("1.0") && !object.equals("1.1")) {
                throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            configuration.setXMLVersion(object.equals("1.0") ? 10 : 11);
        } else {
            throw new IllegalArgumentException("Unknown attribute " + string);
        }
    }

    public Object getConfigurationProperty(String string) {
        Configuration configuration = this;
        if (string.equals("http://saxon.sf.net/feature/treeModel")) {
            return new Integer(configuration.getTreeModel());
        }
        if (string.equals("http://saxon.sf.net/feature/timing")) {
            return configuration.isTiming();
        }
        if (string.equals("http://saxon.sf.net/feature/validation")) {
            return configuration.isValidation();
        }
        if (string.equals("http://saxon.sf.net/feature/schema-validation")) {
            return new Integer(configuration.getSchemaValidationMode());
        }
        if (string.equals("http://saxon.sf.net/feature/validation-warnings")) {
            return configuration.isValidationWarnings();
        }
        if (string.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return configuration.isAllowExternalFunctions();
        }
        if (string.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            return configuration.getSystemURIResolver().queryParametersAreRecognized();
        }
        if (string.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return configuration.isTraceExternalFunctions();
        }
        if (string.equals("http://saxon.sf.net/feature/version-warning")) {
            return configuration.isVersionWarning();
        }
        if (string.equals("http://saxon.sf.net/feature/traceListener")) {
            return configuration.getTraceListener();
        }
        if (string.equals("http://saxon.sf.net/feature/linenumbering")) {
            return configuration.isLineNumbering();
        }
        if (string.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return new Integer(configuration.getRecoveryPolicy());
        }
        if (string.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return configuration.getMessageEmitterClass();
        }
        if (string.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return configuration.getSourceParserClass();
        }
        if (string.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return configuration.getStyleParserClass();
        }
        if (string.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return configuration.getOutputURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/namePool")) {
            return configuration.getNamePool();
        }
        if (string.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            return configuration.getCollationURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            return configuration.getCollectionURIResolver();
        }
        throw new IllegalArgumentException("Unknown attribute " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

