/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class DDMEXCSATReplyDataStream
extends DDMDataStream {
    DDMEXCSATReplyDataStream() {
    }

    boolean checkReply() {
        if (this.getCodePoint() != 5187) {
            String string;
            Trace.log(2, "DDM EXCSAT failed with code point:", this.data_, 8, 2);
            switch (this.getCodePoint()) {
                case 4658: {
                    string = "Permanent agent error.";
                    break;
                }
                case 4636: {
                    string = "Not authorized to command.";
                    break;
                }
                case 4692: {
                    string = "Command check.";
                    break;
                }
                case 4688: {
                    string = "Command not supported.";
                    break;
                }
                case 4689: {
                    string = "Parameter not supported.";
                    break;
                }
                case 8730: {
                    string = "RDB access failed reply message.";
                    break;
                }
                case 8707: {
                    string = "Not authorized to RDB.";
                    break;
                }
                case 4684: {
                    string = "Data stream syntax error.";
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (string != null) {
                Trace.log(2, string);
            }
            return false;
        }
        return true;
    }

    byte[] getEXTNAM() {
        byte[] byArray = null;
        int n = 6;
        int n2 = this.get16bit(n);
        if (n2 <= 4) {
            if (Trace.traceOn_) {
                Trace.log(4, "Insufficient reply length: 0x" + Integer.toHexString(n2));
            }
            return new byte[0];
        }
        n += 4;
        while (n <= this.data_.length - 4) {
            int n3 = this.get16bit(n);
            int n4 = this.get16bit(n + 2);
            switch (n4) {
                case 4446: {
                    if (n3 > 4) {
                        byArray = new byte[n3 - 4];
                        System.arraycopy(this.data_, n + 4, byArray, 0, byArray.length);
                        break;
                    }
                    if (!Trace.traceOn_) break;
                    Trace.log(4, "No data returned in EXTNAM term.");
                }
            }
            n += n3;
        }
        return byArray == null ? new byte[]{} : byArray;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving DDM EXCSAT Reply...");
        }
        if (this.readFromStream(inputStream, byArray = new byte[6], 0, 6) < 6) {
            Trace.log(2, "Failed to read all of the DDM EXCSAT reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToUnsignedShort(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 6);
        this.readAfterHeader(inputStream);
    }
}

