/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;

public class ArrayResourceList
extends ResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private Resource[] resources_;

    public ArrayResourceList(Resource[] resourceArray, Presentation presentation, ResourceMetaData[] resourceMetaDataArray) {
        super(presentation, resourceMetaDataArray, null, null);
        this.setArray(resourceArray);
    }

    public void open() throws ResourceException {
        super.open();
        for (int i = 0; i < this.resources_.length; ++i) {
            this.fireResourceAdded(this.resources_[i], i);
        }
        this.fireLengthChanged(this.resources_.length);
        this.fireListCompleted();
    }

    public Resource resourceAt(long l) throws ResourceException {
        super.resourceAt(l);
        return this.resources_[(int)l];
    }

    protected void setArray(Resource[] resourceArray) {
        if (resourceArray == null) {
            throw new NullPointerException("resources");
        }
        for (int i = 0; i < resourceArray.length; ++i) {
            if (resourceArray[i] != null) continue;
            throw new NullPointerException("resources[" + i + "]");
        }
        this.resources_ = resourceArray;
    }
}

