/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;

class ProgramMapEntry
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final ResourceLevel defaultLevel_ = new ResourceLevel();
    private String programName_ = null;
    private String dataName_ = null;
    private int[] indices_ = null;
    private String countName_ = null;
    private ResourceLevel level_ = null;
    private ValueMap valueMap_ = null;

    public ProgramMapEntry(String string, String string2, int[] nArray, ValueMap valueMap, ResourceLevel resourceLevel) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.programName_ = string;
        this.dataName_ = string2;
        this.indices_ = nArray;
        this.countName_ = null;
        this.valueMap_ = valueMap;
        this.level_ = resourceLevel == null ? defaultLevel_ : resourceLevel;
    }

    public ProgramMapEntry(String string, String string2, String string3, ValueMap valueMap, ResourceLevel resourceLevel) {
        if (string2 == null) {
            throw new NullPointerException("dataName");
        }
        this.programName_ = string;
        this.dataName_ = string2;
        this.indices_ = null;
        this.countName_ = string3;
        this.valueMap_ = valueMap;
        this.level_ = resourceLevel == null ? defaultLevel_ : resourceLevel;
    }

    public String getProgramName() {
        return this.programName_;
    }

    public ResourceLevel getLevel() {
        return this.level_;
    }

    public Object getValue(AS400 aS400, ProgramCallDocument programCallDocument, String string, int[] nArray, int n) throws PcmlException {
        Object object;
        int[] nArray2;
        if (string != null && this.programName_ != null) {
            throw new ExtendedIllegalArgumentException("programName", 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string == null ? this.programName_ : string);
        stringBuffer.append('.');
        stringBuffer.append(this.dataName_);
        String string2 = stringBuffer.toString();
        if (nArray != null && this.indices_ != null) {
            throw new ExtendedIllegalArgumentException("indices", 2);
        }
        int[] nArray3 = nArray2 = nArray == null ? this.indices_ : nArray;
        if (nArray2 == null && this.countName_ == null) {
            object = ProgramMapEntry.isStringValue(programCallDocument, string2) ? programCallDocument.getStringValue(string2, n) : programCallDocument.getValue(string2);
        } else if (this.countName_ == null) {
            object = ProgramMapEntry.isStringValue(programCallDocument, string2) ? programCallDocument.getStringValue(string2, nArray2, n) : programCallDocument.getValue(string2, nArray2);
        } else {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string == null ? this.programName_ : string);
            stringBuffer.append('.');
            stringBuffer.append(this.countName_);
            String string3 = stringBuffer.toString();
            int n2 = programCallDocument.getIntValue(string3);
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = programCallDocument.getValue(string2, new int[]{i});
            }
            object = objectArray;
        }
        if (this.valueMap_ != null) {
            object = this.valueMap_.ptol(object, aS400);
        }
        return object;
    }

    private static boolean isStringValue(ProgramCallDocument programCallDocument, String string) {
        Descriptor descriptor = programCallDocument.getDescriptor().getDescriptor(string);
        if (descriptor == null) {
            return false;
        }
        String string2 = descriptor.getAttributeValue("type");
        if (string2 == null) {
            return false;
        }
        return string2.equals("string");
    }

    public void setValue(AS400 aS400, ProgramCallDocument programCallDocument, String string, int[] nArray, Object object, int n) throws PcmlException {
        int[] nArray2;
        if (string != null && this.programName_ != null) {
            throw new ExtendedIllegalArgumentException("programName", 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string == null ? this.programName_ : string);
        stringBuffer.append('.');
        stringBuffer.append(this.dataName_);
        String string2 = stringBuffer.toString();
        if (nArray != null && this.indices_ != null) {
            throw new ExtendedIllegalArgumentException("indices", 2);
        }
        int[] nArray3 = nArray2 = nArray == null ? this.indices_ : nArray;
        if (this.valueMap_ != null) {
            object = this.valueMap_.ltop(object, aS400);
        }
        if (nArray2 == null) {
            if (object instanceof String) {
                programCallDocument.setStringValue(string2, (String)object, n);
            } else {
                programCallDocument.setValue(string2, object);
            }
        } else if (object instanceof String) {
            programCallDocument.setStringValue(string2, nArray2, (String)object, n);
        } else {
            programCallDocument.setValue(string2, nArray2, object);
        }
    }
}

