/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.time.ZoneId;

public abstract class AvroJavaTimeDeserializerBase<T>
extends StdScalarDeserializer<T> {
    protected AvroJavaTimeDeserializerBase(Class<T> supportedType) {
        super(supportedType);
    }

    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
        if (p.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            ZoneId defaultZoneId = context.getTimeZone().toZoneId().normalized();
            return this.fromLong(p.getLongValue(), defaultZoneId);
        }
        return (T)context.handleUnexpectedToken(this._valueClass, p);
    }

    protected abstract T fromLong(long var1, ZoneId var3);
}

