/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.gui.TestingGuiPlugin;

@ExtensionPoint(extensionPointId="HopGuiPipelineBeforeStart", id="HopGuiFlagPipelineForUnitTestExtensionPoint", description="Change the pipeline variables prior to execution but only in HopGui")
public class HopGuiFlagPipelineForUnitTestExtensionPoint
implements IExtensionPoint<IPipelineEngine> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine pipeline) throws HopException {
        IPipelineEngineRunConfiguration runConfig = pipeline.getPipelineRunConfiguration().getEngineRunConfiguration();
        if (!(runConfig instanceof LocalPipelineRunConfiguration)) {
            pipeline.setVariable("__UnitTest_Run__", "N");
            return;
        }
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipeline.getPipelineMeta());
        if (unitTest == null) {
            return;
        }
        String unitTestName = unitTest.getName();
        if (!StringUtil.isEmpty((String)unitTestName)) {
            pipeline.setVariable("__UnitTest_Run__", variables.getVariable("__UnitTest_Run__"));
            pipeline.setVariable("__UnitTest_Name__", variables.getVariable("__UnitTest_Name__"));
        }
    }
}

