/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject;

import java.io.InputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.PomModel;
import org.kie.api.builder.ReleaseId;

public class ReleaseIdImpl
extends AFReleaseIdImpl
implements ReleaseId {
    private static final String PROJECT_VERSION_MAVEN_PROPERTY = "${project.version}";
    private static final String PARENT_VERSION_MAVEN_PROPERTY = "${project.parent.version}";

    public ReleaseIdImpl() {
    }

    public ReleaseIdImpl(String releaseId) {
        super(releaseId);
    }

    public ReleaseIdImpl(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version);
    }

    public ReleaseIdImpl(String groupId, String artifactId, String version, String type) {
        super(groupId, artifactId, version, type);
    }

    public static ReleaseId adapt(AFReleaseId r) {
        return ReleaseIdImpl.adapt(r, null);
    }

    public static ReleaseId adapt(AFReleaseId r, PomModel pomModel) {
        if (r instanceof ReleaseId) {
            return (ReleaseId)r;
        }
        ReleaseIdImpl newReleaseIdImpl = new ReleaseIdImpl(r.getGroupId(), r.getArtifactId(), ReleaseIdImpl.resolveVersion(r.getVersion(), pomModel), ((AFReleaseIdImpl)r).getType());
        if (r.isSnapshot()) {
            newReleaseIdImpl.setSnapshotVersion(r.getVersion());
        }
        return newReleaseIdImpl;
    }

    public static Collection<ReleaseId> adaptAll(Collection<AFReleaseId> rs, PomModel pomModel) {
        return rs.stream().map(releaseId -> ReleaseIdImpl.adapt(releaseId, pomModel)).collect(Collectors.toList());
    }

    public static ReleaseId fromPropertiesString(String path) {
        return ReleaseIdImpl.adapt(AFReleaseIdImpl.fromPropertiesString((String)path));
    }

    public static ReleaseId fromPropertiesStream(InputStream stream, String path) {
        return ReleaseIdImpl.adapt(AFReleaseIdImpl.fromPropertiesStream((InputStream)stream, (String)path));
    }

    public static String resolveVersion(String versionString, PomModel projectPomModel) {
        if (projectPomModel != null) {
            if (PROJECT_VERSION_MAVEN_PROPERTY.equals(versionString)) {
                return projectPomModel.getReleaseId().getVersion();
            }
            if (PARENT_VERSION_MAVEN_PROPERTY.equals(versionString) && projectPomModel.getParentReleaseId() != null) {
                return projectPomModel.getParentReleaseId().getVersion();
            }
            return versionString;
        }
        return versionString;
    }
}

