/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document;

import com.amazonaws.annotation.Beta;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.QueryFilter;
import com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import com.amazonaws.services.dynamodbv2.document.ScanFilter;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.api.QueryApi;
import com.amazonaws.services.dynamodbv2.document.api.ScanApi;
import com.amazonaws.services.dynamodbv2.document.internal.IndexQueryImpl;
import com.amazonaws.services.dynamodbv2.document.internal.IndexScanImpl;
import com.amazonaws.services.dynamodbv2.document.internal.ScanImpl;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.document.spec.UpdateTableSpec;
import com.amazonaws.services.dynamodbv2.model.DeleteGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.IndexStatus;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.xspec.QueryExpressionSpec;
import com.amazonaws.services.dynamodbv2.xspec.ScanExpressionSpec;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class Index
implements QueryApi,
ScanApi {
    private static final long SLEEP_TIME_MILLIS = 5000L;
    private final Table table;
    private final String indexName;
    private final QueryApi queryDelegate;
    private final ScanImpl scanDelegate;

    Index(AmazonDynamoDB client, String indexName, Table table) {
        if (client == null) {
            throw new IllegalArgumentException("client must be specified");
        }
        if (indexName == null || indexName.trim().length() == 0) {
            throw new IllegalArgumentException("index name must not be null or empty");
        }
        if (table == null) {
            throw new IllegalArgumentException("table must be specified");
        }
        this.table = table;
        this.indexName = indexName;
        this.queryDelegate = new IndexQueryImpl(client, this);
        this.scanDelegate = new IndexScanImpl(client, this);
    }

    public final Table getTable() {
        return this.table;
    }

    public final String getIndexName() {
        return this.indexName;
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String projectionExpression, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Beta
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryExpressionSpec queryExpressions) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, queryExpressions.getFilterExpression(), queryExpressions.getProjectionExpression(), queryExpressions.getNameMap(), queryExpressions.getValueMap());
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.queryDelegate.query(spec);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.queryDelegate.query(hashKey);
    }

    public TableDescription updateGSI(ProvisionedThroughput provisionedThroughput) {
        return this.table.updateTable(new UpdateTableSpec().withGlobalSecondaryIndexUpdates(new GlobalSecondaryIndexUpdate().withUpdate(new UpdateGlobalSecondaryIndexAction().withIndexName(this.indexName).withProvisionedThroughput(provisionedThroughput))));
    }

    public TableDescription deleteGSI() {
        return this.table.updateTable(new UpdateTableSpec().withGlobalSecondaryIndexUpdates(new GlobalSecondaryIndexUpdate().withDelete(new DeleteGlobalSecondaryIndexAction().withIndexName(this.indexName))));
    }

    public TableDescription waitForActive() throws InterruptedException {
        TableDescription desc;
        List<GlobalSecondaryIndexDescription> list;
        Table table = this.getTable();
        String tableName = table.getTableName();
        String indexName = this.getIndexName();
        block4: while ((list = (desc = table.waitForActive()).getGlobalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : list) {
                if (!d.getIndexName().equals(indexName)) continue;
                String status = d.getIndexStatus();
                switch (IndexStatus.fromValue(status)) {
                    case ACTIVE: {
                        return desc;
                    }
                    case CREATING: 
                    case UPDATING: {
                        Thread.sleep(5000L);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Global Secondary Index " + indexName + " is not being created or updated (with status=" + status + ")");
            }
        }
        throw new IllegalArgumentException("Global Secondary Index " + indexName + " does not exist in Table " + tableName + ")");
    }

    public TableDescription waitForDelete() throws InterruptedException {
        TableDescription desc;
        List<GlobalSecondaryIndexDescription> list;
        String indexName = this.getIndexName();
        block0: while ((list = (desc = this.getTable().waitForActive()).getGlobalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : list) {
                if (!d.getIndexName().equals(indexName)) continue;
                String status = d.getIndexStatus();
                if (IndexStatus.fromValue(status) == IndexStatus.DELETING) {
                    Thread.sleep(5000L);
                    continue block0;
                }
                throw new IllegalArgumentException("Global Secondary Index " + indexName + " is not being deleted (with status=" + status + ")");
            }
        }
        return desc;
    }

    public TableDescription waitForActiveOrDelete() throws InterruptedException {
        TableDescription desc;
        List<GlobalSecondaryIndexDescription> list;
        Table table = this.getTable();
        String indexName = this.getIndexName();
        block0: while ((list = (desc = table.waitForActive()).getGlobalSecondaryIndexes()) != null) {
            for (GlobalSecondaryIndexDescription d : desc.getGlobalSecondaryIndexes()) {
                if (!d.getIndexName().equals(indexName)) continue;
                String status = d.getIndexStatus();
                if (IndexStatus.fromValue(status) == IndexStatus.ACTIVE) {
                    return desc;
                }
                Thread.sleep(5000L);
                continue block0;
            }
        }
        return desc;
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanFilter ... scanFilters) {
        return this.scanDelegate.scan(scanFilters);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Beta
    public ItemCollection<ScanOutcome> scan(ScanExpressionSpec xspec) {
        return this.scanDelegate.scan(xspec.getFilterExpression(), xspec.getProjectionExpression(), xspec.getNameMap(), xspec.getValueMap());
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanSpec params) {
        return this.scanDelegate.scan(params);
    }
}

