/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.IOObject;
import com.microsoft.azure.eventhubs.impl.Operation;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.RequestResponseChannel;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseOpener
implements Operation<RequestResponseChannel> {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(RequestResponseOpener.class);
    private final SessionProvider sessionProvider;
    private final String clientId;
    private final String sessionName;
    private final String linkName;
    private final String endpointAddress;
    private final AmqpConnection eventDispatcher;
    private final ScheduledExecutorService executor;
    private final String instanceName = StringUtil.getRandomString("RRO");
    private RequestResponseChannel currentChannel = null;
    private final Object isOpenedSynchronizer = new Object();
    private volatile boolean isOpening = false;

    public RequestResponseOpener(SessionProvider sessionProvider, String clientId, String sessionName, String linkName, String endpointAddress, AmqpConnection eventDispatcher, ScheduledExecutorService executor) {
        this.sessionProvider = sessionProvider;
        this.clientId = clientId;
        this.sessionName = sessionName;
        this.linkName = linkName;
        this.endpointAddress = endpointAddress;
        this.eventDispatcher = eventDispatcher;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run(final OperationResult<RequestResponseChannel, Exception> operationCallback) {
        RequestResponseChannel requestResponseChannel;
        Object object = this.isOpenedSynchronizer;
        synchronized (object) {
            if (this.currentChannel != null && (this.currentChannel.getState() == IOObject.IOObjectState.OPENED || this.currentChannel.getState() == IOObject.IOObjectState.OPENING)) {
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "clientId[%s] rro[%s] inner channel rrc[%s] currently [%s], no need to recreate", this.clientId, this.instanceName, this.currentChannel.getId(), this.currentChannel.getState().toString()));
                }
                return;
            }
            if (this.isOpening) {
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "clientId[%s] rro[%s] inner channel creation already in progress", this.clientId, this.instanceName));
                }
                return;
            }
            this.isOpening = true;
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format(Locale.US, "clientId[%s] rro[%s] opening inner channel", this.clientId, this.instanceName));
            }
        }
        Session session = this.sessionProvider.getSession(this.sessionName, null, (error, exception) -> {
            if (error != null) {
                operationCallback.onError(ExceptionUtil.toException(error));
            } else if (exception != null) {
                operationCallback.onError((Exception)exception);
            }
        });
        if (session == null) {
            if (TRACE_LOGGER.isErrorEnabled()) {
                TRACE_LOGGER.error(String.format(Locale.US, "clientId[%s] rro[%s] got a null session, inner channel recreation cannot continue", this.clientId, this.instanceName));
            }
            Object object2 = this.isOpenedSynchronizer;
            synchronized (object2) {
                this.isOpening = false;
            }
            return;
        }
        this.currentChannel = requestResponseChannel = new RequestResponseChannel(this.linkName, this.endpointAddress, session, this.executor);
        requestResponseChannel.open(new OperationResult<Void, Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete(Void result) {
                RequestResponseOpener.this.eventDispatcher.registerForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.registerForConnectionError((Link)requestResponseChannel.getReceiveLink());
                operationCallback.onComplete(requestResponseChannel);
                Object object = RequestResponseOpener.this.isOpenedSynchronizer;
                synchronized (object) {
                    RequestResponseOpener.this.isOpening = false;
                }
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "requestResponseChannel.onOpen complete clientId[%s], session[%s], link[%s], endpoint[%s], rrc[%s]", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress, requestResponseChannel.getId()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Exception error) {
                operationCallback.onError(error);
                Object object = RequestResponseOpener.this.isOpenedSynchronizer;
                synchronized (object) {
                    RequestResponseOpener.this.currentChannel = null;
                    RequestResponseOpener.this.isOpening = false;
                }
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "requestResponseChannel.onOpen error clientId[%s], session[%s], link[%s], endpoint[%s], error %s", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress, error.getMessage()));
                }
            }
        }, new OperationResult<Void, Exception>(){

            @Override
            public void onComplete(Void result) {
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "requestResponseChannel.onClose complete clientId[%s], session[%s], link[%s], endpoint[%s], rrc[%s]", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress, requestResponseChannel.getId()));
                }
            }

            @Override
            public void onError(Exception error) {
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
                if (TRACE_LOGGER.isWarnEnabled()) {
                    TRACE_LOGGER.warn(String.format(Locale.US, "requestResponseChannel.onClose error clientId[%s], session[%s], link[%s], endpoint[%s], rrc[%s], error %s", RequestResponseOpener.this.clientId, RequestResponseOpener.this.sessionName, RequestResponseOpener.this.linkName, RequestResponseOpener.this.endpointAddress, requestResponseChannel.getId(), error.getMessage()));
                }
            }
        });
    }
}

