/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.generic;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="GENERIC", typeDescription="Generic database", documentationUrl="/database/databases.html")
@GuiPlugin(description="Generic database GUI Plugin")
public class GenericDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String ATRRIBUTE_CUSTOM_DRIVER_CLASS = "CUSTOM_DRIVER_CLASS";
    public static final String DATABASE_DIALECT_ID = "DATABASE_DIALECT_ID";
    private IDatabase databaseDialect = null;
    @GuiWidgetElement(id="hostname", type=GuiElementType.NONE, parentId="DatabaseMeta-PluginSpecific-Options", ignored=true)
    protected String hostname;
    @GuiWidgetElement(id="port", type=GuiElementType.NONE, parentId="DatabaseMeta-PluginSpecific-Options", ignored=true)
    protected String port;
    @GuiWidgetElement(id="databaseName", type=GuiElementType.NONE, parentId="DatabaseMeta-PluginSpecific-Options", ignored=true)
    protected String databaseName;
    @GuiWidgetElement(id="driverClass", order="10", label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.DriverClass", type=GuiElementType.TEXT, variables=true, parentId="DatabaseMeta-PluginSpecific-Options")
    protected String driverClass;

    public void setDriverClass(String driverClass) {
        this.getAttributes().put(ATRRIBUTE_CUSTOM_DRIVER_CLASS, driverClass);
    }

    public String getDriverClass() {
        return this.getAttributeProperty(ATRRIBUTE_CUSTOM_DRIVER_CLASS, "");
    }

    public void addAttribute(String attributeId, String value) {
        super.addAttribute(attributeId, value);
        if (DATABASE_DIALECT_ID.equals(attributeId)) {
            this.resolveDialect(value);
        }
    }

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getNotFoundTK(boolean useAutoIncrement) {
        if (this.isSupportsAutoInc() && useAutoIncrement) {
            return 1;
        }
        return super.getNotFoundTK(useAutoIncrement);
    }

    public String getURL(String hostname, String port, String databaseName) {
        return this.manualUrl;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getTruncateTableStatement(tableName);
        }
        return "DELETE FROM " + tableName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getAddColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
        }
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getModifyColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
        }
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoIncrement, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoIncrement, boolean addFieldName, boolean addCr) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFieldDefinition(v, tk, pk, useAutoIncrement, addFieldName, addCr);
        }
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = (String)retval + "BIGSERIAL";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = (String)retval + "NUMERIC(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    retval = (String)retval + "INTEGER";
                    break;
                }
                retval = (String)retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = (String)retval + "TEXT";
                    break;
                }
                retval = (String)retval + "VARCHAR";
                retval = length > 0 ? (String)retval + "(" + length : (String)retval + "(";
                retval = (String)retval + ")";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public boolean isSupportsPreparedStatementMetadataRetrieval() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsPreparedStatementMetadataRetrieval();
        }
        return false;
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlInsertAutoIncUnknownDimensionRow(schemaTable, keyField, versionField);
        }
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }

    public void setDatabaseDialect(String databaseDialect) {
        super.addAttribute(DATABASE_DIALECT_ID, databaseDialect);
        this.resolveDialect(databaseDialect);
    }

    public String getDatabaseDialect() {
        return super.getAttribute(DATABASE_DIALECT_ID, this.getPluginName());
    }

    private void resolveDialect(String dialectName) {
        if (dialectName == null) {
            return;
        }
        if (dialectName.equals(this.getPluginName())) {
            this.databaseDialect = null;
        } else {
            IDatabase[] dialects;
            for (IDatabase dialect : dialects = DatabaseMeta.getDatabaseInterfaces()) {
                if (!dialectName.equals(dialect.getPluginName())) continue;
                this.databaseDialect = dialect;
                break;
            }
        }
    }

    public String[] getReservedWords() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getReservedWords();
        }
        return super.getReservedWords();
    }

    public String getEndQuote() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getEndQuote();
        }
        return super.getEndQuote();
    }

    public String getFunctionSum() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionSum();
        }
        return super.getFunctionSum();
    }

    public String getFunctionAverage() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionAverage();
        }
        return super.getFunctionAverage();
    }

    public String getFunctionMinimum() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionMinimum();
        }
        return super.getFunctionMinimum();
    }

    public String getFunctionMaximum() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionMaximum();
        }
        return super.getFunctionMaximum();
    }

    public String getFunctionCount() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionCount();
        }
        return super.getFunctionCount();
    }

    public String getSqlQueryFields(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlQueryFields(tableName);
        }
        return super.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlColumnExists(columnname, tableName);
        }
        return super.getSqlColumnExists(columnname, tableName);
    }

    public String getSqlTableExists(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlTableExists(tableName);
        }
        return super.getSqlTableExists(tableName);
    }

    public String getLimitClause(int nrRows) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getLimitClause(nrRows);
        }
        return super.getLimitClause(nrRows);
    }

    public String getSelectCountStatement(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSelectCountStatement(tableName);
        }
        return super.getSelectCountStatement(tableName);
    }

    public String getSqlUnlockTables(String[] tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlUnlockTables(tableName);
        }
        return super.getSqlUnlockTables(tableName);
    }

    public String getSequenceNoMaxValueOption() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSequenceNoMaxValueOption();
        }
        return super.getSequenceNoMaxValueOption();
    }

    public boolean useSchemaNameForTableList() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.useSchemaNameForTableList();
        }
        return super.useSchemaNameForTableList();
    }

    public boolean isSupportsViews() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsViews();
        }
        return super.isSupportsViews();
    }

    public boolean isSupportsTimeStampToDateConversion() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsTimeStampToDateConversion();
        }
        return super.isSupportsTimeStampToDateConversion();
    }

    public String getCreateTableStatement() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getCreateTableStatement();
        }
        return super.getCreateTableStatement();
    }

    public boolean isSupportsAutoGeneratedKeys() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsAutoGeneratedKeys();
        }
        return super.isSupportsAutoGeneratedKeys();
    }

    public String getSafeFieldname(String fieldname) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSafeFieldname(fieldname);
        }
        return super.getSafeFieldname(fieldname);
    }

    public void setSupportsTimestampDataType(boolean b) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setSupportsTimestampDataType(b);
        }
        super.setSupportsTimestampDataType(b);
    }

    public boolean isSupportsTimestampDataType() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsTimestampDataType();
        }
        return super.isSupportsTimestampDataType();
    }

    public boolean isSupportsResultSetMetadataRetrievalOnly() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsResultSetMetadataRetrievalOnly();
        }
        return super.isSupportsResultSetMetadataRetrievalOnly();
    }

    public String getSqlValue(IValueMeta valueMeta, Object valueData, String dateFormat) throws HopValueException {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlValue(valueMeta, valueData, dateFormat);
        }
        return super.getSqlValue(valueMeta, valueData, dateFormat);
    }

    public IValueMeta customizeValueFromSqlType(IValueMeta v, ResultSetMetaData rm, int index) throws SQLException {
        if (this.databaseDialect != null) {
            return this.databaseDialect.customizeValueFromSqlType(v, rm, index);
        }
        return super.customizeValueFromSqlType(v, rm, index);
    }

    public boolean isMySqlVariant() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isMySqlVariant();
        }
        return super.isMySqlVariant();
    }

    public String generateColumnAlias(int columnIndex, String suggestedName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.generateColumnAlias(columnIndex, suggestedName);
        }
        return super.generateColumnAlias(columnIndex, suggestedName);
    }

    public String quoteSqlString(String string) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.quoteSqlString(string);
        }
        return super.quoteSqlString(string);
    }

    public boolean isExplorable() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isExplorable();
        }
        return super.isExplorable();
    }

    public int getMaxColumnsInIndex() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getMaxColumnsInIndex();
        }
        return super.getMaxColumnsInIndex();
    }

    public String getSqlListOfSchemas() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlListOfSchemas();
        }
        return super.getSqlListOfSchemas();
    }

    public boolean isSupportsNewLinesInSql() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsNewLinesInSql();
        }
        return super.isSupportsNewLinesInSql();
    }

    public boolean isSystemTable(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSystemTable(tableName);
        }
        return super.isSystemTable(tableName);
    }

    public boolean isDisplaySizeTwiceThePrecision() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isDisplaySizeTwiceThePrecision();
        }
        return super.isDisplaySizeTwiceThePrecision();
    }

    public boolean isRequiresCastToVariousForIsNull() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isRequiresCastToVariousForIsNull();
        }
        return super.isRequiresCastToVariousForIsNull();
    }

    public boolean isRequiresCreateTablePrimaryKeyAppend() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isRequiresCreateTablePrimaryKeyAppend();
        }
        return super.isRequiresCreateTablePrimaryKeyAppend();
    }

    public boolean isSupportsSequenceNoMaxValueOption() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsSequenceNoMaxValueOption();
        }
        return super.isSupportsSequenceNoMaxValueOption();
    }

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
        }
        super.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
    }

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isUsingDoubleDecimalAsSchemaTableSeparator();
        }
        return super.isUsingDoubleDecimalAsSchemaTableSeparator();
    }

    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setForcingIdentifiersToUpperCase(forceUpperCase);
        }
        super.setForcingIdentifiersToUpperCase(forceUpperCase);
    }

    public boolean isForcingIdentifiersToUpperCase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isForcingIdentifiersToUpperCase();
        }
        return super.isForcingIdentifiersToUpperCase();
    }

    public void setForcingIdentifiersToLowerCase(boolean forceUpperCase) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setForcingIdentifiersToLowerCase(forceUpperCase);
        }
        super.setForcingIdentifiersToLowerCase(forceUpperCase);
    }

    public boolean isForcingIdentifiersToLowerCase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isForcingIdentifiersToLowerCase();
        }
        return super.isForcingIdentifiersToLowerCase();
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setQuoteAllFields(quoteAllFields);
        }
        super.setQuoteAllFields(quoteAllFields);
    }

    public boolean isQuoteAllFields() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isQuoteAllFields();
        }
        return super.isQuoteAllFields();
    }

    public void setStreamingResults(boolean useStreaming) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setStreamingResults(useStreaming);
        }
        super.setStreamingResults(useStreaming);
    }

    public boolean isStreamingResults() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isStreamingResults();
        }
        return super.isStreamingResults();
    }

    public boolean isSupportsSetMaxRows() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsSetMaxRows();
        }
        return super.isSupportsSetMaxRows();
    }

    public boolean isSupportsGetBlob() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsGetBlob();
        }
        return super.isSupportsGetBlob();
    }

    public boolean isDefaultingToUppercase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isDefaultingToUppercase();
        }
        return super.isDefaultingToUppercase();
    }

    public void setPreserveReservedCase(boolean b) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setPreserveReservedCase(b);
        }
        super.setPreserveReservedCase(b);
    }

    public boolean isPreserveReservedCase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isPreserveReservedCase();
        }
        return super.isPreserveReservedCase();
    }

    public void setSupportsBooleanDataType(boolean b) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setSupportsBooleanDataType(b);
        }
        super.setSupportsBooleanDataType(b);
    }

    public boolean isSupportsBooleanDataType() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsBooleanDataType();
        }
        return super.isSupportsBooleanDataType();
    }

    public boolean isSupportsBatchUpdates() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsBatchUpdates();
        }
        return super.isSupportsBatchUpdates();
    }

    public String getSqlLockTables(String[] tableNames) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSqlLockTables(tableNames);
        }
        return super.getSqlLockTables(tableNames);
    }

    public boolean isSupportsFloatRoundingOnUpdate() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsFloatRoundingOnUpdate();
        }
        return super.isSupportsFloatRoundingOnUpdate();
    }

    public boolean isSupportsSynonyms() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsSynonyms();
        }
        return super.isSupportsSynonyms();
    }

    public String[] getSynonymTypes() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSynonymTypes();
        }
        return super.getSynonymTypes();
    }

    public String[] getViewTypes() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getViewTypes();
        }
        return super.getViewTypes();
    }

    public String[] getTableTypes() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getTableTypes();
        }
        return super.getTableTypes();
    }

    public String getStartQuote() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getStartQuote();
        }
        return super.getStartQuote();
    }

    public boolean isQuoteReservedWords() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isQuoteReservedWords();
        }
        return super.isQuoteReservedWords();
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getDropColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
        }
        return super.getDropColumnStatement(tableName, v, tk, useAutoIncrement, pk, semicolon);
    }

    public int getMaxVARCHARLength() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getMaxVARCHARLength();
        }
        return super.getMaxVARCHARLength();
    }

    public int getMaxTextFieldLength() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getMaxTextFieldLength();
        }
        return super.getMaxTextFieldLength();
    }

    public String getSchemaTableCombination(String schemaName, String tablePart) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSchemaTableCombination(schemaName, tablePart);
        }
        return super.getSchemaTableCombination(schemaName, tablePart);
    }

    public Map<String, String> getDefaultOptions() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getDefaultOptions();
        }
        return super.getDefaultOptions();
    }

    public Map<String, String> getExtraOptions() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptions();
        }
        return super.getExtraOptions();
    }

    public void addExtraOption(String databaseTypeCode, String option, String value) {
        if (this.databaseDialect != null) {
            this.databaseDialect.addExtraOption(databaseTypeCode, option, value);
        }
        super.addExtraOption(databaseTypeCode, option, value);
    }

    public String getExtraOptionSeparator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionSeparator();
        }
        return super.getExtraOptionSeparator();
    }

    public String getExtraOptionValueSeparator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionValueSeparator();
        }
        return super.getExtraOptionValueSeparator();
    }

    public String getExtraOptionIndicator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionIndicator();
        }
        return super.getExtraOptionIndicator();
    }

    public boolean isSupportsOptionsInURL() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSupportsOptionsInURL();
        }
        return super.isSupportsOptionsInURL();
    }

    public String getExtraOptionsHelpText() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionsHelpText();
        }
        return super.getExtraOptionsHelpText();
    }

    public boolean isRequiresName() {
        return false;
    }
}

