/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.URI;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.driver.net.ServerAddress;

public class BoltServerAddress
implements ServerAddress {
    public static final int DEFAULT_PORT = 7687;
    public static final BoltServerAddress LOCAL_DEFAULT = new BoltServerAddress("localhost", 7687);
    protected final String host;
    private final String connectionHost;
    protected final int port;
    private final String stringValue;

    public BoltServerAddress(String address) {
        this(BoltServerAddress.uriFrom(address));
    }

    public BoltServerAddress(URI uri) {
        this(BoltServerAddress.hostFrom(uri), BoltServerAddress.portFrom(uri));
    }

    public BoltServerAddress(String host, int port) {
        this(host, host, port);
    }

    public BoltServerAddress(String host, String connectionHost, int port) {
        this.host = Objects.requireNonNull(host, "host");
        this.connectionHost = Objects.requireNonNull(connectionHost, "connectionHost");
        this.port = BoltServerAddress.requireValidPort(port);
        this.stringValue = host.equals(connectionHost) ? String.format("%s:%d", host, port) : String.format("%s(%s):%d", host, connectionHost, port);
    }

    public static BoltServerAddress from(ServerAddress address) {
        return address instanceof BoltServerAddress ? (BoltServerAddress)address : new BoltServerAddress(address.host(), address.port());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltServerAddress address = (BoltServerAddress)o;
        return this.port == address.port && this.host.equals(address.host) && this.connectionHost.equals(address.connectionHost);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.connectionHost, this.port);
    }

    public String toString() {
        return this.stringValue;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    public String connectionHost() {
        return this.connectionHost;
    }

    public Stream<BoltServerAddress> unicastStream() {
        return Stream.of(this);
    }

    private static String hostFrom(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            throw BoltServerAddress.invalidAddressFormat(uri);
        }
        return host;
    }

    private static int portFrom(URI uri) {
        int port = uri.getPort();
        return port == -1 ? 7687 : port;
    }

    private static URI uriFrom(String address) {
        String hostPort;
        String scheme;
        String[] schemeSplit = address.split("://");
        if (schemeSplit.length == 1) {
            scheme = "bolt://";
            hostPort = BoltServerAddress.hostPortFrom(schemeSplit[0]);
        } else if (schemeSplit.length == 2) {
            scheme = schemeSplit[0] + "://";
            hostPort = BoltServerAddress.hostPortFrom(schemeSplit[1]);
        } else {
            throw BoltServerAddress.invalidAddressFormat(address);
        }
        return URI.create(scheme + hostPort);
    }

    private static String hostPortFrom(String address) {
        boolean containsSingleColon;
        if (address.startsWith("[")) {
            return address;
        }
        boolean bl = containsSingleColon = address.indexOf(":") == address.lastIndexOf(":");
        if (containsSingleColon) {
            return address;
        }
        return "[" + address + "]";
    }

    private static RuntimeException invalidAddressFormat(URI uri) {
        return BoltServerAddress.invalidAddressFormat(uri.toString());
    }

    private static RuntimeException invalidAddressFormat(String address) {
        return new IllegalArgumentException("Invalid address format `" + address + "`");
    }

    private static int requireValidPort(int port) {
        if (port >= 0 && port <= 65535) {
            return port;
        }
        throw new IllegalArgumentException("Illegal port: " + port);
    }
}

