/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.SideInputReference;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BatchSideInputHandlerFactory
implements StateRequestHandlers.SideInputHandlerFactory {
    private final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> sideInputToCollection;
    private final @UnknownKeyFor @NonNull @Initialized SideInputGetter sideInputGetter;

    public static @UnknownKeyFor @NonNull @Initialized BatchSideInputHandlerFactory forStage(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, @UnknownKeyFor @NonNull @Initialized SideInputGetter sideInputGetter) {
        ImmutableMap.Builder sideInputBuilder = ImmutableMap.builder();
        for (SideInputReference sideInput : stage.getSideInputs()) {
            sideInputBuilder.put((Object)RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(sideInput.transform().getId()).setLocalName(sideInput.localName()).build(), (Object)sideInput.collection());
        }
        return new BatchSideInputHandlerFactory((Map<RunnerApi.ExecutableStagePayload.SideInputId, PipelineNode.PCollectionNode>)sideInputBuilder.build(), sideInputGetter);
    }

    private BatchSideInputHandlerFactory(@UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId,  @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> sideInputToCollection, @UnknownKeyFor @NonNull @Initialized SideInputGetter sideInputGetter) {
        this.sideInputToCollection = sideInputToCollection;
        this.sideInputGetter = sideInputGetter;
    }

    @Override
    public <V, W extends BoundedWindow>  @UnknownKeyFor @NonNull @Initialized StateRequestHandlers.IterableSideInputHandler<V, W> forIterableSideInput(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, final @UnknownKeyFor @NonNull @Initialized Coder<V> elementCoder, final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        PipelineNode.PCollectionNode collectionNode = this.sideInputToCollection.get(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(transformId).setLocalName(sideInputId).build());
        Preconditions.checkArgument((collectionNode != null ? 1 : 0) != 0, (String)"No side input for %s/%s", (Object)transformId, (Object)sideInputId);
        ImmutableMultimap.Builder windowToValuesBuilder = ImmutableMultimap.builder();
        List broadcastVariable = this.sideInputGetter.getSideInput(collectionNode.getId());
        for (WindowedValue windowedValue : broadcastVariable) {
            Iterator iterator = windowedValue.getWindows().iterator();
            while (iterator.hasNext()) {
                BoundedWindow boundedWindow;
                BoundedWindow window = boundedWindow = (BoundedWindow)iterator.next();
                windowToValuesBuilder.put(windowCoder.structuralValue((Object)window), windowedValue.getValue());
            }
        }
        final ImmutableMultimap windowToValues = windowToValuesBuilder.build();
        return new StateRequestHandlers.IterableSideInputHandler<V, W>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(W window) {
                return windowToValues.get(windowCoder.structuralValue(window));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<V> elementCoder() {
                return elementCoder;
            }
        };
    }

    @Override
    public <K, V, W extends BoundedWindow>  @UnknownKeyFor @NonNull @Initialized StateRequestHandlers.MultimapSideInputHandler<K, V, W> forMultimapSideInput(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, final @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> elementCoder, final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        PipelineNode.PCollectionNode collectionNode = this.sideInputToCollection.get(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(transformId).setLocalName(sideInputId).build());
        Preconditions.checkArgument((collectionNode != null ? 1 : 0) != 0, (String)"No side input for %s/%s", (Object)transformId, (Object)sideInputId);
        final Coder keyCoder = elementCoder.getKeyCoder();
        final HashMap<Object, Map> data = new HashMap<Object, Map>();
        List broadcastVariable = this.sideInputGetter.getSideInput(collectionNode.getId());
        for (WindowedValue windowedValue : broadcastVariable) {
            Object key = ((KV)windowedValue.getValue()).getKey();
            Object value = ((KV)windowedValue.getValue()).getValue();
            Iterator iterator = windowedValue.getWindows().iterator();
            while (iterator.hasNext()) {
                BoundedWindow boundedWindow;
                BoundedWindow window = boundedWindow = (BoundedWindow)iterator.next();
                Object structuralW = windowCoder.structuralValue((Object)window);
                Object structuralK = keyCoder.structuralValue(key);
                KV records = data.computeIfAbsent(structuralW, o -> new HashMap()).computeIfAbsent(structuralK, o -> KV.of((Object)key, new ArrayList()));
                ((List)records.getValue()).add(value);
            }
        }
        return new StateRequestHandlers.MultimapSideInputHandler<K, V, W>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K key, W window) {
                KV records = (KV)data.getOrDefault(windowCoder.structuralValue(window), Collections.emptyMap()).get(keyCoder.structuralValue(key));
                if (records == null) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList((List)records.getValue());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder() {
                return elementCoder.getValueCoder();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterable<K> get(W window) {
                Map records = data.getOrDefault(windowCoder.structuralValue(window), Collections.emptyMap());
                return Iterables.unmodifiableIterable((Iterable)FluentIterable.concat((Iterable[])new Iterable[]{records.values()}).transform(kListKV -> kListKV.getKey()));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder() {
                return elementCoder.getKeyCoder();
            }
        };
    }

    public static interface SideInputGetter {
        public <T> @UnknownKeyFor @NonNull @Initialized List<T> getSideInput(@UnknownKeyFor @NonNull @Initialized String var1);
    }
}

