/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.probes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.impl.util.BenchmarkClosure;
import org.yardstickframework.impl.util.BenchmarkProcessLauncher;

public class DStatProbe
implements BenchmarkProbe {
    private static final String PATH = "BENCHMARK_PROBE_DSTAT_PATH";
    private static final String OPTS = "BENCHMARK_PROBE_DSTAT_OPTS";
    private static final int DEFAULT_INTERVAL_IN_SECS = 1;
    private static final String DEFAULT_PATH = "dstat";
    private static final String DEFAULT_OPTS = "-m --all --noheaders --noupdate 1";
    private static final String FIRST_LINE_RE = "^\\W*\\w*-*memory-usage-* -*total-cpu-usage-* -*dsk/total-* -*net/total-* -*paging-* -*system-*\\s*$";
    private static final Pattern FIRST_LINE = Pattern.compile("^\\W*\\w*-*memory-usage-* -*total-cpu-usage-* -*dsk/total-* -*net/total-* -*paging-* -*system-*\\s*$");
    private static final String HEADER_LINE_RE = "^\\s*used\\s+buff\\s+cach\\s+free\\s*\\Q|\\E\\s*usr\\s+sys\\s+idl\\s+wai\\s+hiq\\s+siq\\s*\\Q|\\E\\s*read\\s+writ\\s*\\Q|\\E\\s*recv\\s+send\\s*\\Q|\\E\\s*in\\s+out\\s*\\Q|\\E\\s*int\\s+csw\\s*$";
    private static final Pattern HEADER_LINE = Pattern.compile("^\\s*used\\s+buff\\s+cach\\s+free\\s*\\Q|\\E\\s*usr\\s+sys\\s+idl\\s+wai\\s+hiq\\s+siq\\s*\\Q|\\E\\s*read\\s+writ\\s*\\Q|\\E\\s*recv\\s+send\\s*\\Q|\\E\\s*in\\s+out\\s*\\Q|\\E\\s*int\\s+csw\\s*$");
    private static final Pattern VALUES_PAT;
    private BenchmarkConfiguration cfg;
    private BenchmarkProcessLauncher proc;
    private Collection<BenchmarkProbePoint> collected = new ArrayList<BenchmarkProbePoint>();

    @Override
    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg) throws Exception {
        this.cfg = cfg;
        BenchmarkClosure<String> c = new BenchmarkClosure<String>(){
            private final AtomicInteger lineNum = new AtomicInteger(0);

            @Override
            public void apply(String s) {
                DStatProbe.this.parseLine(this.lineNum.getAndIncrement(), s);
            }
        };
        this.proc = new BenchmarkProcessLauncher();
        ArrayList<String> cmdParams = new ArrayList<String>();
        cmdParams.add(DStatProbe.path(cfg));
        cmdParams.addAll(DStatProbe.opts(cfg));
        String execCmd = ((Object)cmdParams).toString().replaceAll(",|\\[|\\]", "");
        try {
            this.proc.exec(cmdParams, Collections.emptyMap(), c);
            BenchmarkUtils.println(cfg, this.getClass().getSimpleName() + " is started. Command: '" + execCmd + "'");
        }
        catch (Exception e) {
            BenchmarkUtils.errorHelp(cfg, "Can not start: '" + execCmd + "'.", e);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.proc != null) {
            this.proc.shutdown(false);
            BenchmarkUtils.println(this.cfg, this.getClass().getSimpleName() + " is stopped.");
        }
    }

    @Override
    public Collection<String> metaInfo() {
        return Arrays.asList("Time, sec", "Memory Used, KB", "Memory Buffered, KB", "Memory Cached, KB", "Memory Free, KB", "CPU User, %", "CPU System, %", "CPU Idle, %", "CPU Wait, %", "CPU Hardware Interrupts", "CPU Software Interrupts", "Disk Read, B", "Disk Write, B", "Network Receive, B", "Network Send, B", "Page In, B", "Page Out, B", "System Interrupts, per sec", "System Context Switches, per sec");
    }

    @Override
    public synchronized Collection<BenchmarkProbePoint> points() {
        Collection<BenchmarkProbePoint> ret = this.collected;
        this.collected = new ArrayList<BenchmarkProbePoint>(ret.size() + 5);
        return ret;
    }

    @Override
    public void buildPoint(long time) {
    }

    private synchronized void collectPoint(BenchmarkProbePoint pnt) {
        this.collected.add(pnt);
    }

    private void parseLine(int lineNum, String line) {
        if (lineNum == 0) {
            Matcher m = FIRST_LINE.matcher(line);
            if (!m.matches()) {
                BenchmarkUtils.println(this.cfg, "WARNING: Unexpected first line: " + line);
            }
        } else if (lineNum == 1) {
            Matcher m = HEADER_LINE.matcher(line);
            if (!m.matches()) {
                BenchmarkUtils.errorHelp(this.cfg, "Header line does not match expected header [exp=" + HEADER_LINE + ", act=" + line + "].");
            }
        } else {
            Matcher m = VALUES_PAT.matcher(line);
            if (m.matches()) {
                try {
                    BenchmarkProbePoint pnt = new BenchmarkProbePoint(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()), new double[]{DStatProbe.parseValueWithUnit(m.group(1)) / 1024.0, DStatProbe.parseValueWithUnit(m.group(2)) / 1024.0, DStatProbe.parseValueWithUnit(m.group(3)) / 1024.0, DStatProbe.parseValueWithUnit(m.group(4)) / 1024.0, DStatProbe.parseValueWithUnit(m.group(5)), DStatProbe.parseValueWithUnit(m.group(6)), DStatProbe.parseValueWithUnit(m.group(7)), DStatProbe.parseValueWithUnit(m.group(8)), DStatProbe.parseValueWithUnit(m.group(9)), DStatProbe.parseValueWithUnit(m.group(10)), DStatProbe.parseValueWithUnit(m.group(11)), DStatProbe.parseValueWithUnit(m.group(12)), DStatProbe.parseValueWithUnit(m.group(13)), DStatProbe.parseValueWithUnit(m.group(14)), DStatProbe.parseValueWithUnit(m.group(15)), DStatProbe.parseValueWithUnit(m.group(16)), DStatProbe.parseValueWithUnit(m.group(17)), DStatProbe.parseValueWithUnit(m.group(18))});
                    this.collectPoint(pnt);
                }
                catch (NumberFormatException e) {
                    BenchmarkUtils.errorHelp(this.cfg, "Can't parse line: " + line, e);
                }
            } else {
                BenchmarkUtils.errorHelp(this.cfg, "Can't parse line: " + line);
            }
        }
    }

    private static double parseValueWithUnit(String val) {
        int multiplier;
        if (val.isEmpty()) {
            throw new NumberFormatException("Value is empty.");
        }
        char last = val.charAt(val.length() - 1);
        if (last == '-') {
            return 0.0;
        }
        if (Character.isDigit(last)) {
            return Double.parseDouble(val);
        }
        if (last == 'B') {
            multiplier = 1;
        } else if (last == 'k') {
            multiplier = 1024;
        } else if (last == 'M') {
            multiplier = 0x100000;
        } else if (last == 'G') {
            multiplier = 0x40000000;
        } else {
            throw new NumberFormatException("Unknown unit of measure: [unit=" + last + ", val=" + val + "]");
        }
        return Double.parseDouble(val.substring(0, val.length() - 1)) * (double)multiplier;
    }

    private static String path(BenchmarkConfiguration cfg) {
        String res = cfg.customProperties().get(PATH);
        return res == null || res.isEmpty() ? DEFAULT_PATH : res;
    }

    private static Collection<String> opts(BenchmarkConfiguration cfg) {
        String res = cfg.customProperties().get(OPTS);
        res = res == null || res.isEmpty() ? DEFAULT_OPTS : res;
        return Arrays.asList(res.split("\\s+"));
    }

    static {
        int numFields = 18;
        StringBuilder sb = new StringBuilder("^\\s*");
        for (int i = 0; i < numFields; ++i) {
            sb.append("(\\d*\\.\\d+\\w?|\\d+\\w?|-)");
            if (i < numFields - 1) {
                if (i == 3 || i == 9 || i == 11 || i == 13 || i == 15) {
                    sb.append("\\s*\\Q|\\E\\s*");
                    continue;
                }
                sb.append("\\s+");
                continue;
            }
            sb.append("\\s*");
        }
        sb.append("\\s*$");
        VALUES_PAT = Pattern.compile(sb.toString());
    }
}

