/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.router.GridTcpRouter;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.client.router.impl.GridTcpRouterImpl;
import org.jetbrains.annotations.Nullable;

public final class GridRouterFactory {
    private static ConcurrentMap<UUID, GridTcpRouterImpl> tcpRouters = new ConcurrentHashMap<UUID, GridTcpRouterImpl>();

    private GridRouterFactory() {
    }

    public static GridTcpRouter startTcpRouter(GridTcpRouterConfiguration cfg) throws IgniteCheckedException {
        GridTcpRouterImpl router = new GridTcpRouterImpl(cfg);
        try {
            router.start();
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to start router: " + e, e);
        }
        GridTcpRouterImpl old = tcpRouters.putIfAbsent(router.id(), router);
        assert (old == null) : "UUIDs collision happens [tcpRouters=" + tcpRouters + ", router=" + router + "]";
        return router;
    }

    public static void stopTcpRouter(UUID tcpRouterId) {
        GridTcpRouterImpl router = (GridTcpRouterImpl)tcpRouters.remove(tcpRouterId);
        if (router != null) {
            router.stop();
        }
    }

    @Nullable
    public static GridTcpRouter tcpRouter(UUID id) {
        return (GridTcpRouter)tcpRouters.get(id);
    }

    public static Collection<GridTcpRouter> allTcpRouters() {
        return new ArrayList<GridTcpRouter>(tcpRouters.values());
    }

    public static void stopAllRouters() {
        Iterator it = tcpRouters.values().iterator();
        while (it.hasNext()) {
            GridTcpRouterImpl router = (GridTcpRouterImpl)it.next();
            it.remove();
            router.stop();
        }
    }
}

