/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"nodeIds", "nodeId", "allNodes"}, optional=true, onlyOneOf=true)
public class SystemViewCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(description="Name of the system view which content should be printed. Both \"SQL\" and \"Java\" styles of system view name are supported (e.g. SQL_TABLES and sql.tables will be handled similarly)")
    private String systemViewName;
    @Argument(description="ID of the node to get the system view from (deprecated. Use --node-ids instead). If not set, random node will be chosen")
    private UUID nodeId;
    @Argument(description="Comma-separated list of nodes IDs to get the system view from. If not set, random node will be chosen", example="nodeId1,nodeId2,..")
    private UUID[] nodeIds;
    @Argument(description="Get the system view from all nodes. If not set, random node will be chosen")
    private boolean allNodes;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.systemViewName);
        U.writeUuid(out, this.nodeId);
        U.writeArray(out, this.nodeIds);
        out.writeBoolean(this.allNodes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.systemViewName = U.readString(in);
        this.nodeId = U.readUuid(in);
        this.nodeIds = U.readArray(in, UUID.class);
        this.allNodes = in.readBoolean();
    }

    public String systemViewName() {
        return this.systemViewName;
    }

    public void systemViewName(String systemViewName) {
        this.systemViewName = systemViewName;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID[] nodeIds() {
        return this.nodeIds;
    }

    public void nodeIds(UUID[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public boolean allNodes() {
        return this.allNodes;
    }

    public void allNodes(boolean allNodes) {
        this.allNodes = allNodes;
    }
}

