/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.systemview.view.ConfigurationView;

public class IgniteConfigurationIterable
implements Iterable<ConfigurationView> {
    private final List<String> pkgs;
    private final Queue<GridTuple3<Object, Iterator<Map.Entry<String, Method>>, String>> iters = new LinkedList<GridTuple3<Object, Iterator<Map.Entry<String, Method>>, String>>();

    public IgniteConfigurationIterable(IgniteConfiguration cfg) {
        String pkgsProp = IgniteSystemProperties.getString("IGNITE_CONFIGURATION_VIEW_PACKAGES");
        this.pkgs = new ArrayList(F.isEmpty(pkgsProp) ? Collections.emptyList() : Arrays.asList(pkgsProp.split(",")));
        this.pkgs.add("org.apache.ignite.");
        this.addToQueue(cfg, "");
    }

    @Override
    public Iterator<ConfigurationView> iterator() {
        return new Iterator<ConfigurationView>(){
            private ConfigurationView next;

            @Override
            public boolean hasNext() {
                this.advance();
                return this.next != null;
            }

            private void advance() {
                if (this.next != null) {
                    return;
                }
                while (!IgniteConfigurationIterable.this.iters.isEmpty() && !IgniteConfigurationIterable.this.iters.peek().get2().hasNext()) {
                    IgniteConfigurationIterable.this.iters.remove();
                }
                if (!IgniteConfigurationIterable.this.iters.isEmpty()) {
                    GridTuple3<Object, Iterator<Map.Entry<String, Method>>, String> curr = IgniteConfigurationIterable.this.iters.peek();
                    try {
                        Map.Entry<String, Method> prop = curr.get2().next();
                        String name = curr.get3().isEmpty() ? prop.getKey() : MetricUtils.metricName(curr.get3(), prop.getKey());
                        Object val = prop.getValue().invoke(curr.get1(), new Object[0]);
                        if (IgniteConfigurationIterable.this.addToQueue(val, name)) {
                            this.advance();
                            return;
                        }
                        this.next = new ConfigurationView(name, val != null && val.getClass().isArray() ? S.arrayToString(val) : U.toStringSafe(val));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IgniteException(e);
                    }
                }
            }

            @Override
            public ConfigurationView next() {
                ConfigurationView next0;
                if (this.next == null) {
                    this.advance();
                }
                if ((next0 = this.next) == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return next0;
            }
        };
    }

    private boolean addToQueue(Object val, String prefix) {
        if (val == null || val.getClass().isEnum()) {
            return false;
        }
        Class<?> cls = val.getClass();
        boolean isArr = cls.isArray();
        if (isArr) {
            cls = cls.getComponentType();
        }
        if (!this.checkPkg(cls.getName())) {
            return false;
        }
        if (isArr) {
            int length = Array.getLength(val);
            if (length == 0) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object el = Array.get(val, i);
                this.iters.add(F.t(el, this.props(el.getClass()), prefix + "[" + i + "]"));
            }
        }
        this.iters.add(F.t(val, this.props(val.getClass()), prefix));
        return true;
    }

    private Iterator<Map.Entry<String, Method>> props(Class<?> cls) {
        TreeMap<String, Method> props = new TreeMap<String, Method>();
        while (cls != Object.class) {
            for (Method mtd : cls.getMethods()) {
                if (!mtd.getName().startsWith("set")) continue;
                String propName = mtd.getName().substring(3);
                Method getter = IgniteConfigurationIterable.methodOrNull(cls, "get" + propName);
                if (getter == null) {
                    getter = IgniteConfigurationIterable.methodOrNull(cls, "is" + propName);
                }
                if (getter == null || props.containsKey(propName)) continue;
                props.put(propName, getter);
            }
            cls = cls.getSuperclass();
        }
        return props.entrySet().iterator();
    }

    private static Method methodOrNull(Class<?> cls, String name) {
        try {
            return cls.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private boolean checkPkg(String name) {
        for (String pkg : this.pkgs) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

