/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMapImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.jetbrains.annotations.Nullable;

public class GridCacheLocalConcurrentMap
extends GridCacheConcurrentMapImpl {
    private final int cacheId;
    private final GridCacheConcurrentMap.CacheMapHolder entryMap;

    public GridCacheLocalConcurrentMap(GridCacheContext cctx, GridCacheMapEntryFactory factory, int initCap) {
        super(factory);
        this.cacheId = cctx.cacheId();
        this.entryMap = new GridCacheConcurrentMap.CacheMapHolder(cctx, new ConcurrentHashMap<KeyCacheObject, GridCacheMapEntry>(initCap, 0.75f, Runtime.getRuntime().availableProcessors() * 2));
    }

    @Override
    public int internalSize() {
        return this.entryMap.map.size();
    }

    @Override
    @Nullable
    protected GridCacheConcurrentMap.CacheMapHolder entriesMap(GridCacheContext cctx) {
        return this.entryMap;
    }

    @Override
    @Nullable
    protected GridCacheConcurrentMap.CacheMapHolder entriesMapIfExists(Integer cacheId) {
        return this.entryMap;
    }

    @Override
    public int publicSize(int cacheId) {
        assert (this.cacheId == cacheId);
        return this.entryMap.size.get();
    }

    @Override
    public void incrementPublicSize(GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        assert (this.cacheId == e.context().cacheId());
        this.entryMap.size.incrementAndGet();
    }

    @Override
    public void decrementPublicSize(GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        assert (this.cacheId == e.context().cacheId());
        this.entryMap.size.decrementAndGet();
    }
}

