/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class PartitionUpdateCounterDebugWrapper
implements PartitionUpdateCounter {
    private final IgniteLogger log;
    private final int partId;
    private final CacheGroupContext grp;
    private final PartitionUpdateCounter delegate;

    public PartitionUpdateCounterDebugWrapper(int partId, PartitionUpdateCounter delegate) {
        this.partId = partId;
        this.grp = delegate.context();
        this.log = this.grp.shared().logger(this.getClass());
        this.delegate = delegate;
    }

    @Override
    public void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        this.delegate.init(initUpdCntr, cntrUpdData);
        this.log.debug("[op=init, grpId=" + this.grp.groupId() + ", grpName=" + this.grp.cacheOrGroupName() + ", caches=" + this.grp.caches() + ", atomicity=" + this.grp.config().getAtomicityMode() + ", syncMode=" + this.grp.config().getWriteSynchronizationMode() + ", mode=" + this.grp.config().getCacheMode() + ", partId=" + this.partId + ", gapsLen=" + (cntrUpdData != null ? cntrUpdData.length : 0) + ", cur=" + this.toString() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInitial(long start, long delta) {
        SB sb = new SB();
        sb.a("[op=updateInitial, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", range=(" + start + "," + delta + "), before=" + this.toString());
        try {
            this.delegate.updateInitial(start, delta);
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        SB sb = new SB();
        sb.a("[op=next, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", before=" + this.toString());
        try {
            long l = this.delegate.next();
            return l;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(long delta) {
        SB sb = new SB();
        sb.a("[op=next, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", delta=" + delta + ", before=" + this.toString());
        try {
            long l = this.delegate.next();
            return l;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(long val) throws IgniteCheckedException {
        SB sb = new SB();
        sb.a("[op=set, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", val=" + val + ", before=" + this.toString());
        try {
            this.delegate.update(val);
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    @Override
    public synchronized GridLongList finalizeUpdateCounters() {
        SB sb = new SB();
        sb.a("[op=finalizeUpdateCounters, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", before=" + this.toString() + "]");
        try {
            GridLongList gridLongList = this.delegate.finalizeUpdateCounters();
            return gridLongList;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long reserve(long delta) {
        SB sb = new SB();
        sb.a("[op=reserve, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", delta=" + delta + ", before=" + this.toString());
        try {
            long l = this.delegate.reserve(delta);
            return l;
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean update(long start, long delta) {
        SB sb = new SB();
        sb.a("[op=update, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", delta=(" + start + "," + delta + "), before=" + this.toString());
        boolean updated = false;
        try {
            updated = this.delegate.update(start, delta);
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
        return updated;
    }

    @Override
    public synchronized void reset() {
        SB sb = new SB();
        sb.a("[op=reset, grpId=" + this.grp.groupId() + ", partId=" + this.partId + ", before=" + this.toString());
        try {
            this.delegate.reset();
        }
        finally {
            this.log.debug(sb.a(", after=" + this.toString() + "]").toString());
        }
    }

    @Override
    public void resetInitialCounter() {
        this.delegate.resetInitialCounter();
    }

    @Override
    public long initial() {
        return this.delegate.initial();
    }

    @Override
    public long get() {
        return this.delegate.get();
    }

    @Override
    public long highestAppliedCounter() {
        return this.delegate.highestAppliedCounter();
    }

    @Override
    public long reserved() {
        return this.delegate.reserved();
    }

    @Override
    @Nullable
    public byte[] getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public boolean sequential() {
        return this.delegate.sequential();
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    public Iterator<long[]> iterator() {
        return null;
    }

    @Override
    public CacheGroupContext context() {
        return this.delegate.context();
    }

    @Override
    public PartitionUpdateCounter copy() {
        return new PartitionUpdateCounterDebugWrapper(this.partId, this.delegate.copy());
    }

    @Override
    public Object comparableState() {
        return this.delegate.comparableState();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        return o instanceof PartitionUpdateCounterDebugWrapper && this.delegate.equals(((PartitionUpdateCounterDebugWrapper)o).delegate);
    }
}

