/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteAtomicConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteIrreparableConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteTransactionalConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridNearReadRepairCheckOnlyFuture
extends GridNearReadRepairAbstractFuture {
    private final boolean skipVals;
    private final boolean needVer;
    private final boolean keepCacheObjects;

    public GridNearReadRepairCheckOnlyFuture(AffinityTopologyVersion topVer, GridCacheContext<?, ?> ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, IgniteInternalTx tx) {
        this(topVer, ctx, keys, strategy, readThrough, taskName, deserializeBinary, recovery, expiryPlc, skipVals, needVer, keepCacheObjects, tx, null);
    }

    private GridNearReadRepairCheckOnlyFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, IgniteInternalTx tx, GridNearReadRepairCheckOnlyFuture remappedFut) {
        super(topVer, ctx, keys, strategy, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx, remappedFut);
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
    }

    @Override
    protected GridNearReadRepairAbstractFuture remapFuture(AffinityTopologyVersion topVer) {
        return new GridNearReadRepairCheckOnlyFuture(topVer, this.ctx, this.keys, this.strategy, this.readThrough, this.taskName, this.deserializeBinary, this.recovery, this.expiryPlc, this.skipVals, this.needVer, this.keepCacheObjects, this.tx, this).init();
    }

    @Override
    protected void reduce() {
        block12: {
            try {
                this.onDone(this.check());
            }
            catch (GridNearReadRepairAbstractFuture.IgniteConsistencyCheckFailedException e) {
                Set<KeyCacheObject> inconsistentKeys = e.keys();
                if (this.remapCnt >= MAX_REMAP_CNT) {
                    if (this.strategy == ReadRepairStrategy.CHECK_ONLY) {
                        this.onDoneIrreparable(inconsistentKeys);
                    }
                    if (this.ctx.atomic()) {
                        try {
                            Map<KeyCacheObject, EntryGetResult> correctedMap = this.correct(inconsistentKeys);
                            assert (!correctedMap.isEmpty());
                            this.onDoneRepairRequired(correctedMap);
                        }
                        catch (GridNearReadRepairAbstractFuture.IgniteConsistencyRepairFailedException rfe) {
                            Map<KeyCacheObject, EntryGetResult> correctedMap = rfe.correctedMap();
                            if (!correctedMap.isEmpty()) {
                                this.onDoneRepairRequired(correctedMap);
                                break block12;
                            }
                            assert (Objects.equals(inconsistentKeys, rfe.irreparableKeys()));
                            this.onDoneIrreparable(inconsistentKeys);
                        }
                        catch (IgniteCheckedException ce) {
                            this.onDone(ce);
                        }
                    }
                    this.onDone(new IgniteTransactionalConsistencyViolationException(inconsistentKeys));
                }
                this.remap(this.ctx.affinity().affinityTopologyVersion());
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
        }
    }

    protected void onDoneIrreparable(Set<KeyCacheObject> irreparableKeys) {
        this.recordConsistencyViolation(irreparableKeys, null);
        this.onDone(new IgniteIrreparableConsistencyViolationException(null, this.ctx.unwrapBinariesIfNeeded(irreparableKeys, !this.deserializeBinary)));
    }

    protected void onDoneRepairRequired(Map<KeyCacheObject, EntryGetResult> correcredMap) {
        this.onDone(new IgniteAtomicConsistencyViolationException(correcredMap, this.correctWithPrimary(correcredMap.keySet()), repairedMap -> this.recordConsistencyViolation((Collection<KeyCacheObject>)repairedMap.keySet(), (Map<KeyCacheObject, EntryGetResult>)repairedMap)));
    }

    public <K, V> IgniteInternalFuture<V> single() {
        return this.init().chain((? super IgniteInternalFuture<R> fut) -> {
            try {
                IgniteBiTuple map = new IgniteBiTuple();
                this.addResult((IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>>)fut, map);
                if (this.skipVals) {
                    Boolean val = map.isEmpty() ? false : (Boolean)F.firstValue(map);
                    return val;
                }
                return F.firstValue(map);
            }
            catch (IgniteCheckedException e) {
                throw new GridClosureException(e);
            }
        });
    }

    public <K, V> IgniteInternalFuture<Map<K, V>> multi() {
        return this.init().chain((? super IgniteInternalFuture<R> fut) -> {
            try {
                HashMap map = U.newHashMap(this.keys.size());
                this.addResult((IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>>)fut, map);
                return map;
            }
            catch (Exception e) {
                throw new GridClosureException(e);
            }
        });
    }

    private <K, V> void addResult(IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> fut, Map<K, V> map) throws IgniteCheckedException {
        for (Map.Entry<KeyCacheObject, EntryGetResult> entry : fut.get().entrySet()) {
            EntryGetResult getRes = entry.getValue();
            if (getRes == null) continue;
            this.ctx.addResult(map, entry.getKey(), (CacheObject)getRes.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, getRes, getRes.version(), 0L, 0L, this.needVer, U.deploymentClassLoader(this.ctx.kernalContext(), U.contextDeploymentClassLoaderId(this.ctx.kernalContext())));
        }
    }
}

