/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.apache.ignite.internal.management.cache.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class PartitionHashRecordV2
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final long MOVING_PARTITION_SIZE = Long.MIN_VALUE;
    @GridToStringExclude
    private PartitionKeyV2 partKey;
    private boolean isPrimary;
    @GridToStringInclude
    private Object consistentId;
    @GridToStringExclude
    private int partHash;
    @GridToStringExclude
    private int partVerHash;
    @GridToStringInclude
    private Object updateCntr;
    @GridToStringExclude
    private long size;
    private PartitionState partitionState;
    @GridToStringExclude
    private int cfKeys;
    @GridToStringExclude
    private int noCfKeys;
    @GridToStringExclude
    private int binKeys;
    @GridToStringExclude
    private int regKeys;
    @GridToStringExclude
    private boolean hasExpiringEntries;

    public PartitionHashRecordV2(PartitionKeyV2 partKey, boolean isPrimary, Object consistentId, Object updateCntr, long size, PartitionState partitionState, IdleVerifyUtility.VerifyPartitionContext ctx) {
        this.partKey = partKey;
        this.isPrimary = isPrimary;
        this.consistentId = consistentId;
        this.partHash = ctx.partHash;
        this.partVerHash = ctx.partVerHash;
        this.updateCntr = updateCntr;
        this.size = size;
        this.partitionState = partitionState;
        this.cfKeys = ctx.cf;
        this.noCfKeys = ctx.noCf;
        this.binKeys = ctx.binary;
        this.regKeys = ctx.regular;
    }

    public PartitionHashRecordV2() {
    }

    public PartitionKeyV2 partitionKey() {
        return this.partKey;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public Object consistentId() {
        return this.consistentId;
    }

    public int partitionHash() {
        return this.partHash;
    }

    public int partitionVersionsHash() {
        return this.partVerHash;
    }

    public Object updateCounter() {
        return this.updateCntr;
    }

    public long size() {
        return this.size;
    }

    public PartitionState partitionState() {
        return this.partitionState;
    }

    public int compactFooterKeys() {
        return this.cfKeys;
    }

    public int noCompactFooterKeys() {
        return this.noCfKeys;
    }

    public int binaryKeys() {
        return this.binKeys;
    }

    public int regularKeys() {
        return this.regKeys;
    }

    public boolean hasExpiringEntries() {
        return this.hasExpiringEntries;
    }

    public void hasExpiringEntries(boolean hasExpiringEntries) {
        this.hasExpiringEntries = hasExpiringEntries;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.partKey);
        out.writeBoolean(this.isPrimary);
        out.writeObject(this.consistentId);
        out.writeInt(this.partHash);
        out.writeInt(this.partVerHash);
        out.writeObject(this.updateCntr);
        out.writeLong(this.size);
        U.writeEnum(out, this.partitionState);
        out.writeInt(this.cfKeys);
        out.writeInt(this.noCfKeys);
        out.writeInt(this.binKeys);
        out.writeInt(this.regKeys);
        out.writeBoolean(this.hasExpiringEntries);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.partKey = (PartitionKeyV2)in.readObject();
        this.isPrimary = in.readBoolean();
        this.consistentId = in.readObject();
        this.partHash = in.readInt();
        this.partVerHash = in.readInt();
        this.updateCntr = in.readObject();
        this.size = in.readLong();
        this.partitionState = protoVer >= 2 ? PartitionState.fromOrdinal(in.readByte()) : (this.size == Long.MIN_VALUE ? PartitionState.MOVING : PartitionState.OWNING);
        this.cfKeys = in.readInt();
        this.noCfKeys = in.readInt();
        this.binKeys = in.readInt();
        this.regKeys = in.readInt();
        this.hasExpiringEntries = in.readBoolean();
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public String toString() {
        return this.size == Long.MIN_VALUE ? S.toString(PartitionHashRecordV2.class, this, "state", (Object)"MOVING") : S.toString(PartitionHashRecordV2.class, this, "size", (Object)this.size, "partHash", (Object)this.partHash, "partVerHash", (Object)this.partVerHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionHashRecordV2 v2 = (PartitionHashRecordV2)o;
        return this.partHash == v2.partHash && this.partVerHash == v2.partVerHash && Objects.equals(this.updateCntr, v2.updateCntr) && this.size == v2.size && this.partKey.equals(v2.partKey) && this.consistentId.equals(v2.consistentId) && this.partitionState == v2.partitionState && this.cfKeys == v2.cfKeys && this.noCfKeys == v2.noCfKeys && this.binKeys == v2.binKeys && this.regKeys == v2.regKeys;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partKey, this.consistentId, this.partHash, this.partVerHash, this.updateCntr, this.size, this.partitionState, this.cfKeys, this.noCfKeys, this.binKeys, this.regKeys});
    }

    public static enum PartitionState {
        OWNING,
        MOVING,
        LOST;

        private static final PartitionState[] VALS;

        @Nullable
        public static PartitionState fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = PartitionState.values();
        }
    }
}

