/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import io.opencensus.common.Scope;
import io.opencensus.implcore.internal.CurrentState;
import io.opencensus.implcore.internal.NoopScope;
import io.opencensus.implcore.tags.CurrentTagMapUtils;
import io.opencensus.implcore.tags.NoopTagMapBuilder;
import io.opencensus.implcore.tags.TagContextUtils;
import io.opencensus.implcore.tags.TagMapBuilderImpl;
import io.opencensus.implcore.tags.TagMapImpl;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.Tagger;
import java.util.Iterator;

public final class TaggerImpl
extends Tagger {
    private final CurrentState state;

    TaggerImpl(CurrentState state) {
        this.state = state;
    }

    public TagMapImpl empty() {
        return TagMapImpl.EMPTY;
    }

    public TagMapImpl getCurrentTagContext() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? TagMapImpl.EMPTY : TaggerImpl.toTagMapImpl(CurrentTagMapUtils.getCurrentTagMap());
    }

    public TagContextBuilder emptyBuilder() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagMapBuilder.INSTANCE : new TagMapBuilderImpl();
    }

    public TagContextBuilder currentBuilder() {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagMapBuilder.INSTANCE : this.toBuilder(CurrentTagMapUtils.getCurrentTagMap());
    }

    public TagContextBuilder toBuilder(TagContext tags) {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopTagMapBuilder.INSTANCE : TaggerImpl.toTagMapBuilderImpl(tags);
    }

    public Scope withTagContext(TagContext tags) {
        return this.state.getInternal() == CurrentState.State.DISABLED ? NoopScope.getInstance() : CurrentTagMapUtils.withTagMap(TaggerImpl.toTagMapImpl(tags));
    }

    private static TagMapImpl toTagMapImpl(TagContext tags) {
        if (tags instanceof TagMapImpl) {
            return (TagMapImpl)tags;
        }
        Iterator i = InternalUtils.getTags((TagContext)tags);
        if (!i.hasNext()) {
            return TagMapImpl.EMPTY;
        }
        TagMapBuilderImpl builder = new TagMapBuilderImpl();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (tag == null) continue;
            TagContextUtils.addTagToBuilder(tag, builder);
        }
        return builder.build();
    }

    private static TagMapBuilderImpl toTagMapBuilderImpl(TagContext tags) {
        if (tags instanceof TagMapImpl) {
            return new TagMapBuilderImpl(((TagMapImpl)tags).getTags());
        }
        TagMapBuilderImpl builder = new TagMapBuilderImpl();
        Iterator i = InternalUtils.getTags((TagContext)tags);
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (tag == null) continue;
            TagContextUtils.addTagToBuilder(tag, builder);
        }
        return builder;
    }
}

