/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSpring;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.yardstick.IgniteBenchmarkArguments;
import org.apache.ignite.yardstick.IgniteBenchmarkUtils;
import org.apache.ignite.yardstick.io.FileUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkServer;
import org.yardstickframework.BenchmarkUtils;

public class IgniteNode
implements BenchmarkServer {
    private static final String DFLT_PORT_RANGE = "47500..47549";
    private Ignite ignite;
    private boolean clientMode;

    public IgniteNode() {
    }

    public IgniteNode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public IgniteNode(boolean clientMode, Ignite ignite) {
        this.clientMode = clientMode;
        this.ignite = ignite;
    }

    public void start(BenchmarkConfiguration cfg) throws Exception {
        IgniteBenchmarkArguments args = new IgniteBenchmarkArguments();
        BenchmarkUtils.jcommander((String[])cfg.commandLineArguments(), (Object)args, (String)"<ignite-node>");
        if (!F.isEmpty(args.systemProperties())) {
            for (Map.Entry<String, String> entry : args.systemProperties().entrySet()) {
                System.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (args.clientNodesAfterId() >= 0 && cfg.memberId() > args.clientNodesAfterId()) {
            this.clientMode = true;
        }
        IgniteBiTuple<IgniteConfiguration, ? extends ApplicationContext> tup = IgniteNode.loadConfiguration(args.configuration());
        IgniteConfiguration c = (IgniteConfiguration)tup.get1();
        assert (c != null);
        if (args.cleanWorkDirectory() && !this.clientMode) {
            FileUtils.cleanDirectory(U.workDirectory((String)c.getWorkDirectory(), (String)c.getIgniteHome()));
        }
        ApplicationContext appCtx = (ApplicationContext)tup.get2();
        assert (appCtx != null);
        CacheConfiguration[] ccfgs = c.getCacheConfiguration();
        if (ccfgs != null) {
            for (CacheConfiguration cc : ccfgs) {
                boolean cl;
                boolean bl = cl = args.isClientOnly() && (args.isNearCache() || this.clientMode);
                if (cl) {
                    c.setClientMode(true);
                }
                if (args.isNearCache()) {
                    NearCacheConfiguration nearCfg = new NearCacheConfiguration();
                    int nearCacheSize = args.getNearCacheSize();
                    if (nearCacheSize != 0) {
                        nearCfg.setNearEvictionPolicy((EvictionPolicy)new LruEvictionPolicy(nearCacheSize));
                    }
                    cc.setNearConfiguration(nearCfg);
                }
                if (args.cacheGroup() != null) {
                    cc.setGroupName(args.cacheGroup());
                }
                cc.setWriteSynchronizationMode(args.syncMode());
                cc.setBackups(args.backups());
                if (args.restTcpPort() != 0) {
                    ConnectorConfiguration ccc = new ConnectorConfiguration();
                    ccc.setPort(args.restTcpPort());
                    if (args.restTcpHost() != null) {
                        ccc.setHost(args.restTcpHost());
                    }
                    c.setConnectorConfiguration(ccc);
                }
                cc.setReadThrough(args.isStoreEnabled());
                cc.setWriteThrough(args.isStoreEnabled());
                cc.setWriteBehindEnabled(args.isWriteBehind());
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Cache configured with the following parameters: " + cc));
            }
        } else {
            BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"There are no caches configured");
        }
        TransactionConfiguration tc = c.getTransactionConfiguration();
        tc.setDefaultTxConcurrency(args.txConcurrency());
        tc.setDefaultTxIsolation(args.txIsolation());
        TcpCommunicationSpi commSpi = (TcpCommunicationSpi)c.getCommunicationSpi();
        if (commSpi == null) {
            commSpi = new TcpCommunicationSpi();
        }
        c.setCommunicationSpi((CommunicationSpi)commSpi);
        if (args.getPageSize() != 4096) {
            DataStorageConfiguration memCfg = c.getDataStorageConfiguration();
            if (memCfg == null) {
                memCfg = new DataStorageConfiguration();
                c.setDataStorageConfiguration(memCfg);
            }
            memCfg.setPageSize(args.getPageSize());
        }
        if (args.persistentStoreEnabled() && c.getDataStorageConfiguration() == null) {
            BenchmarkUtils.println((String)String.format("Setting 'persistenceEnabled' property to 'true'. WAL mode is %s", args.walMode()));
            DataStorageConfiguration pcCfg = new DataStorageConfiguration();
            pcCfg.getDefaultDataRegionConfiguration().setPersistenceEnabled(true);
            pcCfg.setWalMode(WALMode.valueOf((String)args.walMode()));
            c.setBinaryConfiguration(new BinaryConfiguration().setCompactFooter(false));
            c.setDataStorageConfiguration(pcCfg);
        }
        if (c.getDiscoverySpi() instanceof TcpDiscoverySpi) {
            this.replaceAdrList(c, cfg);
        }
        this.ignite = IgniteSpring.start((IgniteConfiguration)c, (ApplicationContext)appCtx);
        BenchmarkUtils.println((String)("Configured marshaller: " + this.ignite.cluster().localNode().attribute("org.apache.ignite.marshaller")));
    }

    public static IgniteBiTuple<IgniteConfiguration, ? extends ApplicationContext> loadConfiguration(String springCfgPath) throws Exception {
        Map cfgMap;
        GenericApplicationContext springCtx;
        URL url;
        block7: {
            try {
                url = new URL(springCfgPath);
            }
            catch (MalformedURLException e) {
                url = IgniteUtils.resolveIgniteUrl((String)springCfgPath);
                if (url != null) break block7;
                throw new IgniteCheckedException("Spring XML configuration path is invalid: " + springCfgPath + ". Note that this path should be either absolute or a relative local file system path, relative to META-INF in classpath or valid URL to IGNITE_HOME.", (Throwable)e);
            }
        }
        try {
            springCtx = new GenericApplicationContext();
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)springCtx).loadBeanDefinitions((Resource)new UrlResource(url));
            springCtx.refresh();
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate Spring XML application context [springUrl=" + url + ", err=" + e.getMessage() + "]", e);
        }
        try {
            cfgMap = springCtx.getBeansOfType(IgniteConfiguration.class);
        }
        catch (BeansException e) {
            throw new Exception("Failed to instantiate bean [type=" + IgniteConfiguration.class + ", err=" + e.getMessage() + "]", e);
        }
        if (cfgMap == null || cfgMap.isEmpty()) {
            throw new Exception("Failed to find ignite configuration in: " + url);
        }
        return new IgniteBiTuple((Object)((IgniteConfiguration)cfgMap.values().iterator().next()), (Object)springCtx);
    }

    public void stop() throws Exception {
        Ignition.stopAll((boolean)true);
    }

    public String usage() {
        return BenchmarkUtils.usage((Object)new IgniteBenchmarkArguments());
    }

    public Ignite ignite() {
        return this.ignite;
    }

    private void replaceAdrList(IgniteConfiguration c, BenchmarkConfiguration cfg) {
        if (cfg.customProperties() == null) {
            return;
        }
        if (cfg.customProperties().get("AUTOSET_DISCOVERY_VM_IP_FINDER") == null || !Boolean.valueOf((String)cfg.customProperties().get("AUTOSET_DISCOVERY_VM_IP_FINDER")).booleanValue()) {
            return;
        }
        if (cfg.customProperties().get("SERVER_HOSTS") == null) {
            return;
        }
        String hosts = (String)cfg.customProperties().get("SERVER_HOSTS");
        HashSet<String> adrSetFromProp = new HashSet<String>(Arrays.asList(hosts.split(",")));
        if (adrSetFromProp.isEmpty()) {
            return;
        }
        TcpDiscoverySpi spi = (TcpDiscoverySpi)c.getDiscoverySpi();
        Collection regAdrList = spi.getIpFinder().getRegisteredAddresses();
        ArrayList<String> adrList = new ArrayList<String>(regAdrList.size());
        for (InetSocketAddress adr : regAdrList) {
            adrList.add(adr.getHostString());
        }
        if (IgniteBenchmarkUtils.checkIfNoLocalhost(adrSetFromProp)) {
            ArrayList<InetSocketAddress> newAdrList = new ArrayList<InetSocketAddress>(adrSetFromProp.size());
            TreeSet<String> toDisplay = new TreeSet<String>();
            String portRange = cfg.customProperties().get("PORT_RANGE") != null ? (String)cfg.customProperties().get("PORT_RANGE") : DFLT_PORT_RANGE;
            for (String adr : adrSetFromProp) {
                for (Integer port : IgniteBenchmarkUtils.getPortList(portRange)) {
                    newAdrList.add(new InetSocketAddress(adr, (int)port));
                }
                toDisplay.add(String.format("/%s:%s", adr, portRange));
            }
            BenchmarkUtils.println((String)"Setting SERVER_HOSTS addresses for IpFinder configuration.");
            BenchmarkUtils.println((String)String.format("Replacing list: \n %s \n to list: \n %s", regAdrList, toDisplay));
            spi.getIpFinder().unregisterAddresses(regAdrList);
            spi.getIpFinder().registerAddresses(newAdrList);
            for (String adr : IgniteUtils.allLocalIps()) {
                if (!adrSetFromProp.contains(adr)) continue;
                BenchmarkUtils.println((String)String.format("Setting 'localhost' property to %s", adr));
                c.setLocalHost(adr);
            }
        }
    }
}

