/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.PersonNoIndex;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlQueryFullScanBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.loadCachesData();
    }

    @Override
    protected void loadCacheData(String cacheName) {
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(cacheName);){
            for (int i = 0; i < this.args.range(); ++i) {
                if (i % 100 == 0 && Thread.currentThread().isInterrupted()) {
                    break;
                }
                dataLdr.addData((Object)i, (Object)new PersonNoIndex(i, "firstName" + i, "lastName" + i, i * 1000));
                if (i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Populated persons: " + i));
            }
        }
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        double salary = ThreadLocalRandom.current().nextDouble() * (double)this.args.range() * 1000.0;
        double maxSalary = salary + 1000.0;
        Collection<Cache.Entry<Integer, Object>> entries = this.executeQuery(salary, maxSalary);
        for (Cache.Entry<Integer, Object> entry : entries) {
            PersonNoIndex p = (PersonNoIndex)entry.getValue();
            if (!(p.getSalary() < salary) && !(p.getSalary() > maxSalary)) continue;
            throw new Exception("Invalid person retrieved [min=" + salary + ", max=" + maxSalary + ", person=" + p + "]");
        }
        return true;
    }

    private Collection<Cache.Entry<Integer, Object>> executeQuery(double minSalary, double maxSalary) throws Exception {
        IgniteCache cache = this.cacheForOperation(true);
        SqlQuery qry = new SqlQuery(PersonNoIndex.class, "salary >= ? and salary <= ?");
        qry.setArgs(new Object[]{minSalary, maxSalary});
        return cache.query((Query)qry).getAll();
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }
}

