/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.dml;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Person;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteSqlUpdateFilteredBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private AtomicInteger putCnt = new AtomicInteger();
    private AtomicInteger updCnt = new AtomicInteger();
    private AtomicLong updItemsCnt = new AtomicLong();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        if (rnd.nextBoolean()) {
            double salary = rnd.nextDouble() * (double)this.args.range() * 1000.0;
            double maxSalary = salary + 1000.0;
            Long res = (Long)((List)this.cache().query(new SqlFieldsQuery("update Person set salary = (salary - ?1 + ?2) / 2 where salary >= ?1 and salary <= ?2").setArgs(new Object[]{salary, maxSalary})).getAll().get(0)).get(0);
            this.updItemsCnt.getAndAdd(res);
            this.updCnt.getAndIncrement();
        } else {
            int i = rnd.nextInt(this.args.range());
            this.cache.put((Object)i, (Object)new Person(i, "firstName" + i, "lastName" + i, i * 1000));
            this.putCnt.getAndIncrement();
        }
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }

    @Override
    public void tearDown() throws Exception {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Finished SQL UPDATE query benchmark [putCnt=" + this.putCnt.get() + ", updCnt=" + this.updCnt.get() + ", updItemsCnt=" + this.updItemsCnt.get() + "]"));
        super.tearDown();
    }
}

