/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class IgniteIndexBound
extends AbstractRelNode
implements SourceAwareIgniteRel {
    private static final double INDEX_NULLS_EXPECTED_RATIO = (double)0.05f;
    private final String idxName;
    private final long sourceId;
    private final boolean first;
    private final RelOptTable tbl;
    private final ImmutableBitSet requiredCols;

    public IgniteIndexBound(RelOptTable tbl, RelOptCluster cluster, RelTraitSet traits, String idxName, boolean first, ImmutableBitSet requiredCols) {
        this(-1L, tbl, cluster, traits, idxName, first, requiredCols);
    }

    private IgniteIndexBound(long sourceId, RelOptTable tbl, RelOptCluster cluster, RelTraitSet traits, String idxName, boolean first, ImmutableBitSet requiredCols) {
        super(cluster, traits);
        this.sourceId = sourceId;
        this.tbl = tbl;
        this.idxName = idxName;
        this.first = first;
        this.requiredCols = requiredCols;
    }

    public IgniteIndexBound(RelInput input) {
        super(input.getCluster(), input.getTraitSet());
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
        this.tbl = input.getTable("table");
        this.idxName = input.getString("index");
        this.first = input.getBoolean("first", true);
        this.requiredCols = input.getBitSet("requiredCols");
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(1.0, this.tbl.getRowCount() * (double)0.05f * 1.0, 0.0);
    }

    public RelDataType deriveRowType() {
        return ((IgniteTable)this.tbl.unwrap(IgniteTable.class)).getRowType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()), this.requiredCols);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L).item("table", (Object)this.tbl.getQualifiedName()).item("index", (Object)this.idxName).item("first", (Object)this.first).item("requiredCols", (Object)this.requiredCols);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteIndexBound(this.sourceId, this.tbl, cluster, this.traitSet, this.idxName, this.first, this.requiredCols);
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteIndexBound(sourceId, this.tbl, this.getCluster(), this.traitSet, this.idxName, this.first, this.requiredCols);
    }

    public RelOptTable getTable() {
        return this.tbl;
    }

    public String indexName() {
        return this.idxName;
    }

    public boolean first() {
        return this.first;
    }

    public ImmutableBitSet requiredColumns() {
        return this.requiredCols;
    }
}

