/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSamplingParameters;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;

public class Sample
extends SingleRel {
    private final RelOptSamplingParameters params;

    public Sample(RelOptCluster cluster, RelNode child, RelOptSamplingParameters params) {
        super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), child);
        this.params = params;
    }

    public Sample(RelInput input) {
        this(input.getCluster(), input.getInput(), Sample.getSamplingParameters(input));
    }

    private static RelOptSamplingParameters getSamplingParameters(RelInput input) {
        int seed;
        boolean repeatable;
        String mode = input.getString("mode");
        boolean bernoulli = "bernoulli".equals(mode);
        BigDecimal rate = input.getBigDecimal("rate");
        Object repeatableSeed = input.get("repeatableSeed");
        if (repeatableSeed instanceof Number) {
            repeatable = true;
            seed = ((Number)repeatableSeed).intValue();
        } else {
            repeatable = false;
            seed = 0;
        }
        return new RelOptSamplingParameters(bernoulli, rate, repeatable, seed);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new Sample(this.getCluster(), Sample.sole(inputs), this.params);
    }

    public RelOptSamplingParameters getSamplingParameters() {
        return this.params;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("mode", this.params.isBernoulli() ? "bernoulli" : "system").item("rate", this.params.sampleRate).item("repeatableSeed", this.params.isRepeatable() ? Integer.valueOf(this.params.getRepeatableSeed()) : "-");
    }
}

