/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.MetadataHandlerProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;

public class ProxyingMetadataHandlerProvider
implements MetadataHandlerProvider {
    private final RelMetadataProvider provider;

    public ProxyingMetadataHandlerProvider(RelMetadataProvider provider) {
        this.provider = provider;
    }

    @Override
    public <MH extends MetadataHandler<?>> MH handler(Class<MH> handlerClass) {
        MetadataDef def;
        Type[] types = handlerClass.getGenericInterfaces();
        if (types.length != 1 || !(types[0] instanceof ParameterizedType)) {
            throw new UnsupportedOperationException("Unexpected failure. " + handlerClass);
        }
        ParameterizedType pType = (ParameterizedType)types[0];
        if (pType.getRawType() != MetadataHandler.class) {
            throw new UnsupportedOperationException("Unexpected failure. " + handlerClass);
        }
        Class metadataType = (Class)pType.getActualTypeArguments()[0];
        try {
            Field field = metadataType.getField("DEF");
            def = Objects.requireNonNull((MetadataDef)field.get(null), () -> "Unexpected failure. " + handlerClass);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        ImmutableList<Method> methods = def.methods;
        Map<String, Method> methodMap = methods.stream().collect(Collectors.toMap(Method::getName, f -> f));
        InvocationHandler handler = (proxy, method, args) -> {
            Method metadataMethod = (Method)Objects.requireNonNull(methodMap.get(method.getName()), () -> "Not supported: " + method);
            RelNode rel = Objects.requireNonNull((RelNode)args[0], "rel must be non null");
            RelMetadataQuery mq = Objects.requireNonNull((RelMetadataQuery)args[1], "mq must be non null");
            UnboundMetadata metadata = this.provider.apply(rel.getClass(), metadataType);
            if (metadata == null) {
                Method handlerMethod = Arrays.stream(handlerClass.getMethods()).filter(m -> m.getName().equals(metadataMethod.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find method."));
                throw new IllegalArgumentException(String.format(Locale.ROOT, "No handler for method [%s] applied to argument of type [%s]; we recommend you create a catch-all (RelNode) handler", handlerMethod, rel.getClass()));
            }
            Object bound = Objects.requireNonNull(metadata, "expected defined metadata").bind(rel, mq);
            Object[] abbreviatedArgs = new Object[args.length - 2];
            System.arraycopy(args, 2, abbreviatedArgs, 0, abbreviatedArgs.length);
            try {
                return metadataMethod.invoke(bound, abbreviatedArgs);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof CyclicMetadataException) {
                    throw (CyclicMetadataException)ex.getCause();
                }
                throw new RuntimeException(ex.getCause());
            }
        };
        return (MH)((MetadataHandler)Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{handlerClass}, handler));
    }
}

