/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.function.Consumer;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheClearCommandArg;
import org.apache.ignite.internal.processors.cache.ClearCachesTask;
import org.apache.ignite.internal.processors.cache.ClearCachesTaskResult;
import org.apache.ignite.internal.util.typedef.F;

public class CacheClearCommand
implements ComputeCommand<CacheClearCommandArg, ClearCachesTaskResult> {
    public static final String CLEAR_MSG = "The following caches have been cleared: %s";
    public static final String SKIP_CLEAR_MSG = "The following caches don't exist: %s";
    public static final String CONFIRM_MSG = "Warning! The command will clear all data from %d caches: %s.\nIf you continue, it will be impossible to recover cleared data.";

    @Override
    public String description() {
        return "Clear specified caches";
    }

    @Override
    public String confirmationPrompt(CacheClearCommandArg arg) {
        return String.format(CONFIRM_MSG, arg.caches().length, String.join((CharSequence)", ", arg.caches()));
    }

    @Override
    public Class<CacheClearCommandArg> argClass() {
        return CacheClearCommandArg.class;
    }

    @Override
    public Class<ClearCachesTask> taskClass() {
        return ClearCachesTask.class;
    }

    @Override
    public void printResult(CacheClearCommandArg arg, ClearCachesTaskResult res, Consumer<String> printer) {
        if (!F.isEmpty(res.clearedCaches())) {
            printer.accept(String.format(CLEAR_MSG, String.join((CharSequence)", ", res.clearedCaches())));
        }
        if (!F.isEmpty(res.nonExistentCaches())) {
            printer.accept(String.format(SKIP_CLEAR_MSG, String.join((CharSequence)", ", res.nonExistentCaches())));
        }
    }
}

