/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheIndexesRebuildStatusCommandArg;
import org.apache.ignite.internal.management.cache.IndexRebuildStatusInfoContainer;
import org.apache.ignite.internal.management.cache.IndexRebuildStatusTask;

public class CacheIndexesRebuildStatusCommand
implements ComputeCommand<CacheIndexesRebuildStatusCommandArg, Map<UUID, Set<IndexRebuildStatusInfoContainer>>> {
    @Override
    public String description() {
        return "List all indexes that have index rebuild in progress";
    }

    @Override
    public Class<CacheIndexesRebuildStatusCommandArg> argClass() {
        return CacheIndexesRebuildStatusCommandArg.class;
    }

    @Override
    public Class<IndexRebuildStatusTask> taskClass() {
        return IndexRebuildStatusTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, CacheIndexesRebuildStatusCommandArg arg) {
        return CommandUtils.nodeOrAll(arg.nodeId(), nodes);
    }

    @Override
    public void printResult(CacheIndexesRebuildStatusCommandArg arg, Map<UUID, Set<IndexRebuildStatusInfoContainer>> res, Consumer<String> printer) {
        if (res.isEmpty()) {
            printer.accept("There are no caches that have index rebuilding in progress.");
            printer.accept("");
            return;
        }
        printer.accept("Caches that have index rebuilding in progress:");
        for (Map.Entry<UUID, Set<IndexRebuildStatusInfoContainer>> entry : res.entrySet()) {
            printer.accept("");
            entry.getValue().stream().sorted(IndexRebuildStatusInfoContainer.comparator()).forEach(container -> printer.accept(this.constructCacheOutputString((UUID)entry.getKey(), (IndexRebuildStatusInfoContainer)container)));
        }
        printer.accept("");
    }

    private String constructCacheOutputString(UUID nodeId, IndexRebuildStatusInfoContainer container) {
        return "node_id=" + nodeId + ", " + container.toString();
    }
}

